/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import model.AUnit;
import model.IMeasurable;
import model.length.Meter;
import model.length.Yard;
import model.temperature.Celsius;
import model.temperature.Fahrenheit;
import model.temperature.Kelvin;
import view.ConversionView;
import view.InputStringDialog;

public class ConvCalcView
extends JPanel {
    private JComboBox _measurablesBox;
    private JList _unitList;

    public ConvCalcView() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setSize(new Dimension(540, 380));
        this.setLayout(new BorderLayout());
        JPanel measurablesPanel = new JPanel();
        measurablesPanel.setLayout(new BorderLayout());
        measurablesPanel.add((Component)new JLabel("Select measurable:"), "North");
        this._measurablesBox = new JComboBox();
        this._measurablesBox.addItem(new ConcreteMeasurableChoice("model.temperature.ITemperature", new AUnit[]{new Celsius(), new Fahrenheit(), new Kelvin()}));
        this._measurablesBox.addItem(new ConcreteMeasurableChoice("model.length.ILength", new AUnit[]{new Meter(), new Yard()}));
        this._measurablesBox.addItem(new AddMeasurableChoice());
        this._measurablesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConvCalcView.this.measurablesBoxSelected(e);
            }
        });
        measurablesPanel.add((Component)this._measurablesBox, "Center");
        this.add((Component)measurablesPanel, "North");
        JPanel unitPanel = new JPanel();
        unitPanel.setLayout(new BorderLayout());
        unitPanel.add((Component)new JLabel("Select units to convert:"), "North");
        this._unitList = new JList();
        JScrollPane sp = new JScrollPane(this._unitList);
        unitPanel.add((Component)sp, "Center");
        this.add((Component)unitPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton convertBtn = new JButton("Convert...");
        convertBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConvCalcView.this.convertBtnClicked(e);
            }
        });
        buttonPanel.add(convertBtn);
        JButton addBtn = new JButton("Add Unit...");
        addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConvCalcView.this.addBtnClicked(e);
            }
        });
        buttonPanel.add(addBtn);
        this.add((Component)buttonPanel, "South");
        ((IMeasurableChoice)this._measurablesBox.getSelectedItem()).select();
    }

    private void addBtnClicked(ActionEvent e) {
        String className = new InputStringDialog((Frame)null, (Component)this, "Enter class name for unit to be added:").showDialog();
        if (!className.equals("")) {
            try {
                Class<?> unitClass = Class.forName(className);
                if (unitClass.getSuperclass() != null && !unitClass.getSuperclass().getName().equals("model.AUnit")) {
                    throw new RuntimeException("Invalid unit class, superclass is not model.AUnit<M extends IMeasurable>: " + unitClass.getSuperclass().getName());
                }
                Type ct = unitClass.getGenericSuperclass();
                if (ct != null && ct instanceof ParameterizedType) {
                    String selectedMeasurableName;
                    ParameterizedType pt = (ParameterizedType)ct;
                    Type[] args = pt.getActualTypeArguments();
                    if (!(args.length == 1 && args[0] instanceof Class || unitClass.getSuperclass().getName().equals("model.AUnit"))) {
                        throw new RuntimeException("Invalid unit class, superclass is not model.AUnit<M extends IMeasurable>: " + unitClass.getSuperclass().getName());
                    }
                    String measurableName = ((Class)args[0]).getName();
                    if (!measurableName.equals(selectedMeasurableName = this._measurablesBox.getSelectedItem().toString())) {
                        throw new RuntimeException("Measurable of unit " + className + " is " + measurableName + ", not " + selectedMeasurableName);
                    }
                } else {
                    throw new RuntimeException("Invalid unit class, superclass is not model.AUnit<M extends IMeasurable>.");
                }
                Constructor<?> unitCtor = unitClass.getConstructor(new Class[0]);
                AUnit unit = (AUnit)unitCtor.newInstance(new Object[0]);
                ((IMeasurableChoice)this._measurablesBox.getSelectedItem()).addUnit(unit);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1);
            }
        }
    }

    private void convertBtnClicked(ActionEvent e) {
        int count = this._unitList.getSelectedValues().length;
        if (count > 1) {
            ArrayList selectedUnits = new ArrayList(count);
            for (Object o : this._unitList.getSelectedValues()) {
                selectedUnits.add((AUnit)o);
            }
            ConversionView cv = new ConversionView(selectedUnits);
            cv.setLocationRelativeTo(this);
            cv.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "Please select two or more units.");
        }
    }

    private void measurablesBoxSelected(ActionEvent e) {
        ((IMeasurableChoice)this._measurablesBox.getSelectedItem()).select();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddMeasurableChoice
    implements IMeasurableChoice {
        private AddMeasurableChoice() {
        }

        public String toString() {
            return "Add...";
        }

        @Override
        public void select() {
            String className = new InputStringDialog((Frame)null, (Component)ConvCalcView.this, "Enter class name for measurable to be added:").showDialog();
            if (!className.equals("")) {
                try {
                    Class<?> measurableClass = Class.forName(className);
                    if (!measurableClass.isInterface() || !IMeasurable.class.isAssignableFrom(measurableClass)) {
                        throw new RuntimeException("Invalid measurable interface or superinterface is not model.IMeasurable.");
                    }
                    ConcreteMeasurableChoice newMeasurableChoice = new ConcreteMeasurableChoice(className, new AUnit[0]);
                    ConvCalcView.this._measurablesBox.insertItemAt(newMeasurableChoice, ConvCalcView.this._measurablesBox.getItemCount() - 1);
                    ConvCalcView.this._measurablesBox.setSelectedItem(newMeasurableChoice);
                    newMeasurableChoice.select();
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(ConvCalcView.this, e1);
                }
            }
        }

        @Override
        public void addUnit(AUnit<? extends IMeasurable> unit) {
            throw new Error("Unit added to \"Add...\" measurable choice. This should never happen!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConcreteMeasurableChoice
    implements IMeasurableChoice {
        String _name;
        DefaultListModel _unitModel;

        public ConcreteMeasurableChoice(String name, AUnit<? extends IMeasurable>[] units) {
            this._name = name;
            this._unitModel = new DefaultListModel();
            for (AUnit<? extends IMeasurable> u : units) {
                this._unitModel.addElement(u);
            }
        }

        public String toString() {
            return this._name;
        }

        @Override
        public void select() {
            ConvCalcView.this._unitList.setModel(this._unitModel);
            ConvCalcView.this.validate();
        }

        @Override
        public void addUnit(AUnit<? extends IMeasurable> unit) {
            this._unitModel.addElement(unit);
            if (ConvCalcView.this._measurablesBox.getSelectedItem() == this) {
                this.select();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IMeasurableChoice {
        public void select();

        public void addUnit(AUnit<? extends IMeasurable> var1);
    }
}

