/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import model.IModelAdapter;

public class TempCalcConsoleView {
    private IModelAdapter _modelAdapter;
    private BufferedReader _br = new BufferedReader(new InputStreamReader(System.in));

    public TempCalcConsoleView(IModelAdapter modelAdapter) {
        this._modelAdapter = modelAdapter;
    }

    public void run() {
        String s;
        System.out.println("Convert temperature between Celsius, Fahrenheit, and Kelvin.");
        do {
            if ((s = this.multipleChoice("Press 'c'/'f'/'k' to convert from Celsius, Fahrenheit, or Kelvin, respectively.", "c", "f", "k")).equals("c")) {
                this.convertC();
            } else if (s.equals("f")) {
                this.convertF();
            } else {
                this.convertK();
            }
            System.out.println("Do you want to convert more temperatures? ");
        } while ((s = this.multipleChoice("Press 'y' for yes, 'n' for no.", "y", "n")).equals("y"));
    }

    private String multipleChoice(String prompt, String ... choices) {
        String s = null;
        boolean repeat = true;
        block2: do {
            System.out.print(prompt + " ");
            try {
                s = this._br.readLine();
            }
            catch (IOException ioe) {
                continue;
            }
            repeat = true;
            for (String c : choices) {
                if (!c.equals(s)) continue;
                repeat = false;
                continue block2;
            }
        } while (repeat);
        return s;
    }

    private void convertC() {
        System.out.println();
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Celsius: ");
            try {
                double d = Double.valueOf(this._br.readLine());
                System.out.println(String.valueOf(d) + " C = " + String.valueOf(this._modelAdapter.convertCtoF(d)) + " F = " + String.valueOf(this._modelAdapter.convertCtoK(d)) + " K");
                repeat = false;
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        } while (repeat);
    }

    private void convertF() {
        System.out.println();
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Fahrenheit: ");
            try {
                double d = Double.valueOf(this._br.readLine());
                System.out.println(String.valueOf(d) + " F = " + String.valueOf(this._modelAdapter.convertFtoC(d)) + " C = " + String.valueOf(this._modelAdapter.convertCtoK(this._modelAdapter.convertFtoC(d))) + " K");
                repeat = false;
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        } while (repeat);
    }

    private void convertK() {
        System.out.println();
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Kelvin: ");
            try {
                double d = Double.valueOf(this._br.readLine());
                System.out.println(String.valueOf(d) + " K = " + String.valueOf(this._modelAdapter.convertKtoC(d)) + " C = " + String.valueOf(this._modelAdapter.convertCtoF(this._modelAdapter.convertKtoC(d))) + " F");
                repeat = false;
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        } while (repeat);
    }
}

