package view;

import javax.swing.*;
import java.awt.*;

/**
 * View of the simple temperature calculator.
 *
 * @author Mathias Ricken
 */
public class TempCalcView extends JPanel {

    /**
     * Constructs a new temperature calculator view.
     */
    public TempCalcView() {
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Initialize the GUI components.
     */
    private void jbInit() {
        setSize(new Dimension(540, 380));
        setLayout(new BorderLayout());
        JLabel degCLabel= new JLabel("35.0");
        degCLabel.setPreferredSize(new Dimension(80, 30));
        JPanel degCPanel = new JPanel();
        degCPanel.setLayout(new FlowLayout());
        degCPanel.add(new JLabel("C"));
        degCPanel.add(degCLabel);
        JLabel degFLabel= new JLabel(String.valueOf((35 / 5.0 * 9) + 32));
        degFLabel.setPreferredSize(new Dimension(80, 30));
        JPanel degFPanel = new JPanel();
        degFPanel.setLayout(new FlowLayout());
        degFPanel.add(new JLabel("= F"));
        degFPanel.add(degFLabel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout());
        topPanel.add(degCPanel);
        topPanel.add(degFPanel);
        add(topPanel, BorderLayout.CENTER);
    }
}
