package controller;

import model.AUnit;
import model.temperature.Celsius;
import model.temperature.Fahrenheit;
import model.temperature.Kelvin;
import view.TempCalcFrame;

/**
 * Main class for command-line use.
 * *
 * @author Mathias Ricken
 * @dependency view.TempCalcView instantiates, passes list of AUnits
 * @dependency model.AUnit instantiates list of AUnits
 */
public class TempCalcApp {
    /**
     * Entry point for Java VM.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        java.util.ArrayList units = new java.util.ArrayList();
        units.add(new Celsius());
        units.add(new Fahrenheit());
        units.add(new Kelvin());
        (new TempCalcFrame(units)).setVisible(true);
    }
}
