package model.temperature;

import model.AUnit;
import model.IBijection;

/**
 * Reamur temperature unit.
 * @author Mathias Ricken
 */
public class Reamur extends AUnit {
    public Reamur() {
        super("R");
    }
    
    /**
     * Conversion function from Reamur to base.
     */
    private final IBijection _func = new IBijection() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection getInverse() {
            return _inverse;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Object apply(Object param) {
            return new Double(((Double)param) / 5.0 * 4.0);
        }
    };
    
    /**
     * Conversion function from base to Reamur.
     */
    private final IBijection _inverse = new IBijection() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection getInverse() {
            return _func;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Object apply(Object param) {
            return new Double(((Double)param) / 5.0 * 4.0);
        }
    };
    
    /**
     * Returns a function that converts a value in this temperature scale to a value in the "base temperature scale".
     * @return conversion function to "base scale"
     */
    protected IBijection getConversionFunction() {
        // we chose to let our "base scale" coincide with the Celsius scale, so the conversion function
        // is the function from Reamur to Celsius, the inverse of the conversion function is the
        // function from Celsius to Reamur
        return _func;
    }
}
