package view;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Dialog to enter a string.
 *
 * @author Mathias Ricken
 */
public class InputStringDialog {
    /**
     * The dialog.
     */
    private JDialog _dialog;
    
    /**
     * Text field.
     */
    private JTextField _textField;
    
    /**
     * Parent component.
     */
    private Component _parent;
    
    /**
     * Creates a new input string dialog and all its controls.
     *
     * @param owner owner dialog for the dialog
     * @param parent parent component used for centering the dialog
     * @param title  window title
     */
    public InputStringDialog(JDialog owner, Component parent, String title) {
        _parent = parent;
        _dialog = new JDialog(owner, title, true);
        _dialog.setContentPane(makeOptionsPanel());
        _dialog.pack();
        _dialog.setResizable(false);
    }
    
    /**
     * Creates a new input string dialog and all its controls.
     *
     * @param owner owner frame for the dialog
     * @param parent parent component used for centering the dialog
     * @param title  window title
     */
    public InputStringDialog(Frame owner, Component parent, String title) {
        _parent = parent;
        _dialog = new JDialog(owner, title, true);
        _dialog.setContentPane(makeOptionsPanel());
        _dialog.pack();
        _dialog.setResizable(false);
    }
    
    /**
     * Show the modal dialog.
     *
     * @return contents of text field
     */
    public String showDialog() {
        _dialog.setLocationRelativeTo(_parent);
        _dialog.setVisible(true); // Modal dialog will block until setVisible(false), see ok/cancel methods
        return _textField.getText();
    }
    
    // callback when user clicks cancel button
    private void cancelClicked() {
        _textField.setText("");
        _dialog.setVisible(false);
    }
    
    // callback when user clicks ok button
    private void okClicked() {
        _dialog.setVisible(false);
    }
    
    /**
     * Build options dialog.
     *
     * @return options pane
     */
    private JOptionPane makeOptionsPanel() {
        JPanel myControls = new JPanel();
        myControls.setLayout(new BoxLayout(myControls, BoxLayout.Y_AXIS));
        _textField = new JTextField();
        myControls.add(_textField);
        JOptionPane optPane = new JOptionPane(myControls, JOptionPane.QUESTION_MESSAGE);
        JButton[] optButtons = new JButton[]{new JButton("Create"), new JButton("Cancel")};
        optPane.setOptions(optButtons);
        optPane.setInitialValue(optButtons[0]);
        optButtons[1].addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cancelClicked();
            }
        });
        optButtons[0].addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                okClicked();
            }
        });
        return optPane;
    }
}


