package controller;

import model.AUnit;
import model.temperature.Celsius;
import model.temperature.Fahrenheit;
import model.temperature.Kelvin;
import view.IView;
import view.LauncherFrame;
import view.console.ConsoleView;
import view.dropDown.DropDownView;
import view.gui.StandardView;

/**
 * Main class for command-line use.
 *
 * @author Mathias Ricken
 */
public class TempCalcApp {
    /**
     * Entry point for Java VM.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        java.util.ArrayList<AUnit> units = new java.util.ArrayList<AUnit>();
        units.add(new Celsius());
        units.add(new Fahrenheit());
        units.add(new Kelvin());
        
        IView[] views = new IView[] { new StandardView(units), new DropDownView(units), new ConsoleView(units) };
        (new LauncherFrame(views, units)).setVisible(true);
    }
}
