package model;

import junit.framework.TestCase;
import model.temperature.Celsius;
import model.temperature.Fahrenheit;
import model.temperature.Kelvin;

/**
 * A JUnit test case class for model.
 */
public class ModelTest extends TestCase {  
    /**
     * Test method for C to F conversion.
     */
    public void testCtoF() {
        Celsius c = new Celsius();
        Fahrenheit f = new Fahrenheit();
        assertEquals(new Measurement(212.0, f),  f.convertTo(new Measurement(100.0, c)));
        assertEquals(new Measurement(32.0, f),   f.convertTo(new Measurement(0.0, c)));
        assertEquals(new Measurement(-148.0, f), f.convertTo(new Measurement(-100.0, c)));
    }    
    
    /**
     * Test method for F to C conversion.
     */
    public void testFtoC() {
        Celsius c = new Celsius();
        Fahrenheit f = new Fahrenheit();
        assertEquals(new Measurement(100.0, c),  c.convertTo(new Measurement(212.0, f)));
        assertEquals(new Measurement(0.0, c),    c.convertTo(new Measurement(32.0, f)));
        assertEquals(new Measurement(-100.0, c), c.convertTo(new Measurement(-148.0, f)));
    } 
    
    /**
     * Test method for C to K conversion.
     */
    public void testCtoK() {
        Celsius c = new Celsius();
        Kelvin k = new Kelvin();
        assertEquals(new Measurement(373.2, k), k.convertTo(new Measurement(100.0, c)));
        assertEquals(new Measurement(273.2, k), k.convertTo(new Measurement(0.0, c)));
        assertEquals(new Measurement(173.2, k), k.convertTo(new Measurement(-100.0, c)));
    }    
    
    /**
     * Test method for K to C conversion.
     */
    public void testKtoC() {
        Celsius c = new Celsius();
        Kelvin k = new Kelvin();
        assertEquals(new Measurement(100, c),    c.convertTo(new Measurement(373.2, k)));
        assertEquals(new Measurement(-273.2, c), c.convertTo(new Measurement(0.0, k)));
        assertEquals(new Measurement(0, c),      c.convertTo(new Measurement(273.2, k)));
    }
    
    /**
     * Test method for F to K conversion.
     */
    public void testFtoK() {
        Fahrenheit f = new Fahrenheit();
        Kelvin k = new Kelvin();
        assertEquals(new Measurement(373.2, k), k.convertTo(new Measurement(212.0, f)));
        assertEquals(new Measurement(273.2, k), k.convertTo(new Measurement(32.0, f)));
        assertEquals(new Measurement(173.2, k), k.convertTo(new Measurement(-148.0, f)));
    }    
    
    /**
     * Test method for K to F conversion.
     */
    public void testKtoF() {
        Fahrenheit f = new Fahrenheit();
        Kelvin k = new Kelvin();
        assertEquals(new Measurement(212.0, f),  f.convertTo(new Measurement(373.2, k)));
        assertEquals(new Measurement(-459.76, f), f.convertTo(new Measurement(0.0, k)));
        assertEquals(new Measurement(32.0, f),   f.convertTo(new Measurement(273.2, k)));
    }
    
    /**
     * Test method for C to C conversion.
     */
    public void testCtoC() {
        Celsius c = new Celsius();
        assertEquals(new Measurement(100.0, c),  c.convertTo(new Measurement(100.0, c)));
        assertEquals(new Measurement(0.0, c),    c.convertTo(new Measurement(0.0, c)));
        assertEquals(new Measurement(-100.0, c), c.convertTo(new Measurement(-100.0, c)));
    }
    
    /**
     * Test method for K to K conversion.
     */
    public void testKtoK() {
        Kelvin k = new Kelvin();
        assertEquals(new Measurement(0.0, k),   k.convertTo(new Measurement(0.0, k)));
        assertEquals(new Measurement(273.2, k), k.convertTo(new Measurement(273.2, k)));
        assertEquals(new Measurement(373.2, k), k.convertTo(new Measurement(373.2, k)));
    }
    
    /**
     * Test custom conversion.
     */
    public void testCustom() {
        Celsius c = new Celsius();
        AUnit custom1 = new AUnit("custom1") { // twice as large as internal scale
            private final IBijection<Double, Double> _func = new IBijection<Double, Double>() {
                public IBijection<Double, Double> getInverse() {
                    return _inverse;
                }
                public Double apply(Double param) {
                    return param / 2;
                }
            };
            private final IBijection<Double, Double> _inverse = new IBijection<Double, Double>() {
                public IBijection<Double, Double> getInverse() {
                    return _func;
                }
                public Double apply(Double param) {
                    return param * 2;
                }
            };
            protected IBijection<Double, Double> getConversionFunction() {
                return _func;
            }
        };
        assertEquals(new Measurement(100.0, c),  c.convertTo(new Measurement(200.0, custom1)));
        assertEquals(new Measurement(0.0, c),    c.convertTo(new Measurement(0.0, custom1)));
        assertEquals(new Measurement(-100.0, c), c.convertTo(new Measurement(-200.0, custom1)));

        assertEquals(new Measurement(100.0, custom1),  custom1.convertTo(new Measurement(50.0, c)));
        assertEquals(new Measurement(20.0, custom1),   custom1.convertTo(new Measurement(10.0, c)));
        assertEquals(new Measurement(-100.0, custom1), custom1.convertTo(new Measurement(-50.0, c)));
        
        AUnit custom2 = new AUnit("custom2") { // 10 less than internal scale
            private final IBijection<Double, Double> _func = new IBijection<Double, Double>() {
                public IBijection<Double, Double> getInverse() {
                    return _inverse;
                }
                public Double apply(Double param) {
                    return param + 10;
                }
            };
            private final IBijection<Double, Double> _inverse = new IBijection<Double, Double>() {
                public IBijection<Double, Double> getInverse() {
                    return _func;
                }
                public Double apply(Double param) {
                    return param - 10;
                }
            };
            protected IBijection<Double, Double> getConversionFunction() {
                return _func;
            }
        };
        assertEquals(new Measurement(90.0, custom2),   custom2.convertTo(new Measurement(200.0, custom1)));
        assertEquals(new Measurement(-10.0, custom2),  custom2.convertTo(new Measurement(0.0, custom1)));
        assertEquals(new Measurement(-110.0, custom2), custom2.convertTo(new Measurement(-200.0, custom1)));

        assertEquals(new Measurement(120.0, custom1),  custom1.convertTo(new Measurement(50.0, custom2)));
        assertEquals(new Measurement(40.0, custom1),   custom1.convertTo(new Measurement(10.0, custom2)));
        assertEquals(new Measurement(-80.0, custom1), custom1.convertTo(new Measurement(-50.0, custom2)));
    }
}
