package view.dropDown;

import model.AUnit;
import model.Measurement;
import view.IView;
import view.InputStringDialog;
import view.TempCalcFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;

/**
 * Temperature calculator drop down view.
 *
 * @author Mathias Ricken
 */
public class DropDownView extends JPanel implements IView {
    /**
     * Frame for this view.
     */
    private TempCalcFrame _frame;
    
    /**
     * Left unit selector.
     */
    private JComboBox _leftUnitBox;
    
    /**
     * Left text field.
     */
    private JTextField _leftTextField;
    
    /**
     * Right unit selector.
     */
    private JComboBox _rightUnitBox;
    
    /**
     * Right text field.
     */
    private JTextField _rightTextField;
    
    /**
     * Constructs a new temperature calculator drop down view.
     *
     * @param units list of units
     */
    public DropDownView(java.util.List<AUnit> units) {
        try {
            jbInit(units);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Run the calculator.
     */
    public void run() {
        _frame.setVisible(true);
    }
    
    /**
     * Initialize the GUI components.
     *
     * @param units list of units to display in this view
     */
    private void jbInit(java.util.List<AUnit> units) {
        setSize(new Dimension(540, 380));
        setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.X_AXIS));
        _leftTextField = new JTextField("0.0");
        _leftTextField.setPreferredSize(new Dimension(80, 30));
        _leftTextField.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                handleLeftChange();
            }
        });
        _leftUnitBox = new JComboBox(units.toArray());
        _leftUnitBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                handleRightChange();
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        p.add(_leftUnitBox);
        p.add(_leftTextField);
        topPanel.add(p);
        _rightTextField = new JTextField("0.0");
        _rightTextField.setPreferredSize(new Dimension(80, 30));
        _rightTextField.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                handleRightChange();
            }
        });
        _rightUnitBox = new JComboBox(units.toArray());
        _rightUnitBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                handleLeftChange();
            }
        });
        _rightUnitBox.setSelectedIndex(Math.min(1, units.size() - 1));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        p.add(_rightUnitBox);
        p.add(_rightTextField);
        topPanel.add(p);
        JButton addButton = new JButton("Add unit...");
        addButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                handleAddUnit();
            }
        });
        p = new JPanel();
        p.add(addButton);
        add(topPanel, BorderLayout.CENTER);
        add(p, BorderLayout.SOUTH);
        handleLeftChange();
        
        _frame = new TempCalcFrame(this,false);
    }
    
    /**
     * Recalculate the temperature after a change in degrees on the left.
     */
    private void handleLeftChange() {
        //        pack();
        DecimalFormat df = new DecimalFormat("#0.0");
        double entered = Double.valueOf(_leftTextField.getText());
        double conv
            = ((AUnit)_rightUnitBox.getSelectedItem()).convertTo(new Measurement(entered,
                                                                                 ((AUnit)_leftUnitBox.getSelectedItem())))
            .getValue();
        _rightTextField.setText(df.format(conv));
    }
    
    /**
     * Recalculate the temperature after a change in degrees on the right.
     */
    private void handleRightChange() {
        //        pack();
        DecimalFormat df = new DecimalFormat("#0.0");
        double entered = Double.valueOf(_rightTextField.getText());
        double conv
            = ((AUnit)_leftUnitBox.getSelectedItem()).convertTo(new Measurement(entered,
                                                                                ((AUnit)_rightUnitBox.getSelectedItem())))
            .getValue();
        _leftTextField.setText(df.format(conv));
    }
    
    /**
     * Add a unit to the combo boxes.
     */
    private void handleAddUnit() {
        //        pack();
        String className = (new InputStringDialog((Frame)null, this,  "Enter class name for unit to be added:")).showDialog();
        if (!className.equals("")) {
            try {
                Class unitClass = Class.forName(className);
                if (!AUnit.class.isAssignableFrom(unitClass)) {
                    throw new RuntimeException("Invalid unit class, superclass is not model.AUnit.");
                }
                Constructor unitCtor = unitClass.getConstructor();
                AUnit unit = (AUnit)unitCtor.newInstance();
                _leftUnitBox.addItem(unit);
                _rightUnitBox.addItem(unit);
            }
            catch(Exception e1) {
                JOptionPane.showMessageDialog(null, e1);
            }
        }
    }
}
