package view.gui;

import model.AUnit;
import model.Measurement;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;

/**
 * Conversion view.
 *
 * @author Mathias Ricken
 */
public class ConversionView extends JFrame {
    /**
     * Class for a text field with associated unit.
     */
    private static class UnitField extends JTextField {
        /**
         * Unit associated with this text field.
         */
        private AUnit _unit;
        
        /**
         * Constructs a new text field with associated unit.
         *
         * @param text text to display in the field
         * @param unit associated unit
         */
        public UnitField(String text, AUnit unit) {
            super(text);
            _unit = unit;
        }
        
        /**
         * Returns the unit associated with this text field.
         *
         * @return associated unit
         */
        public AUnit getUnit() {
            return _unit;
        }
    }
    
    /**
     * List of units in this conversion view.
     */
    private java.util.List<UnitField> _unitFields;
    
    /**
     * Constructs a new conversion view.
     *
     * @param units list of units to display in this view
     */
    public ConversionView(java.util.List<AUnit> units) {
        super("Conversions");
        try {
            jbInit(units);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Initialize the GUI components.
     *
     * @param units list of units to display in this view
     */
    private void jbInit(java.util.List<AUnit> units) {
        setSize(new Dimension(540, 380));
        Container cp = getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.X_AXIS));
        _unitFields = new ArrayList<UnitField>(units.size());
        for(AUnit u : units) {
            UnitField f = new UnitField("0.0", u);
            f.setPreferredSize(new Dimension(80, 30));
            f.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    handleChange((UnitField)e.getSource());
                }
            });
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
            p.add(new JLabel(u.toString()));
            p.add(f);
            topPanel.add(p);
            _unitFields.add(f);
        }
        cp.add(topPanel, BorderLayout.CENTER);
        handleChange(_unitFields.get(0));
    }
    
    /**
     * Recalculate the temperature after a change in degrees Fahrenheit.
     */
    private void handleChange(UnitField source) {
        pack();
        DecimalFormat df = new DecimalFormat("#0.0");
        double entered = Double.valueOf(source.getText());
        for(UnitField uf : _unitFields) {
            if (uf != source) {
                // only convert if field is not the one where enter was pressed
                double conv = uf.getUnit().convertTo(new Measurement(entered, source.getUnit())).getValue();
                uf.setText(df.format(conv));
            }
        }
    }
}
