package view.gui;

import model.AUnit;
import view.IView;
import view.InputStringDialog;
import view.TempCalcFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

/**
 * Standard view of the conversion calculator.
 *
 * @author Mathias Ricken
 */
public class StandardView extends JPanel implements IView {
    /**
     * Frame for this view.
     */
    private TempCalcFrame _frame;
    
    /**
     * List model with different units.
     */
    private DefaultListModel _unitListModel;
    
    /**
     * Listbox with different units.
     */
    private JList _unitList;
    
    /**
     * Panel with different units.
     */
    private JPanel _unitPanel;
    
    /**
     * Constructs a new standard conversion calculator view.
     *
     * @param units list of units
     */
    public StandardView(java.util.List<AUnit> units) {
        _unitListModel = new DefaultListModel();
        for(AUnit u : units) {
            _unitListModel.addElement(u);
        }
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Run the calculator.
     */
    public void run() {
        _frame.setVisible(true);
    }
    
    /**
     * Initialize the GUI components.
     */
    private void jbInit() {
        setSize(new Dimension(540, 380));
        setLayout(new BorderLayout());
        _unitPanel = new JPanel();
        _unitPanel.setLayout(new BorderLayout());
        _unitPanel.add(new JLabel("Select units to convert:"), BorderLayout.NORTH);
        _unitList = new JList(_unitListModel);
        JScrollPane sp = new JScrollPane(_unitList);
        _unitPanel.add(sp, BorderLayout.CENTER);
        add(_unitPanel, BorderLayout.CENTER);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton convertBtn = new JButton("Convert...");
        convertBtn.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                convertBtnClicked(e);
            }
        });
        buttonPanel.add(convertBtn);
        JButton addBtn = new JButton("Add Unit...");
        addBtn.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                addBtnClicked(e);
            }
        });
        buttonPanel.add(addBtn);
        add(buttonPanel, BorderLayout.SOUTH);
        
        _frame = new TempCalcFrame(this, false);
    }
    
    /**
     * The add button was clicked.
     *
     * @param e action event
     */
    private void addBtnClicked(ActionEvent e) {
        String className = (new InputStringDialog((Frame)null, this, "Enter class name for unit to be added:")).showDialog();
        if (!className.equals("")) {
            try {
                Class unitClass = Class.forName(className);
                if (!AUnit.class.isAssignableFrom(unitClass)) {
                    throw new RuntimeException("Invalid unit class, superclass is not model.AUnit.");
                }
                Constructor unitCtor = unitClass.getConstructor();
                AUnit unit = (AUnit)unitCtor.newInstance();
                _unitListModel.addElement(unit);
            }
            catch(Exception e1) {
                JOptionPane.showMessageDialog(this, e1);
            }
        }
    }
    
    /**
     * The convert button was clicked.
     * @param e action event
     */
    private void convertBtnClicked(ActionEvent e) {
        int count = _unitList.getSelectedValues().length;
        if (count > 1) {
            ArrayList<AUnit> selectedUnits = new ArrayList<AUnit>(count);
            for(Object o : _unitList.getSelectedValues()) {
                selectedUnits.add((AUnit)o);
            }
            ConversionView cv = new ConversionView(selectedUnits);
            cv.setLocationRelativeTo(this);
            cv.setVisible(true);
        }
        else {
            JOptionPane.showMessageDialog(this, "Please select two or more units.");
        }
    }
}
