package controller;

import view.ConvCalcView;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * Main class for applet use. Displays a button first.
 *
 * @author Mathias Ricken
 */
public class ConvCalcButtonApplet extends JApplet {
    /**
     * Button to start the calculator.
     */
    private JButton _startBtn = new JButton();
    
    /**
     * Initializes the applet - requred for all applets.
     */
    public void init() {
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Initialize components.
     */
    private void jbInit() {
        _startBtn.setFont(new java.awt.Font("Dialog", 1, 16));
        _startBtn.setText("Click here to run the Conversion Calculator!");
        _startBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                startBtn_actionPerformed(e);
            }
        });
        getContentPane().add(_startBtn, BorderLayout.CENTER);
    }
    
    /**
     * Gets executed when the start button is pushed.
     *
     * @param e event
     */
    private void startBtn_actionPerformed(ActionEvent e) {
        getContentPane().add(new ConvCalcView());
        getContentPane().remove(_startBtn);
        validate();
    }
}
