package model;

/**
 * Interface for a bijection, i.e. a lambda that can provide its own inverse.
 * @author Mathias Ricken
 */
public interface IBijection <R,P> extends ILambda<R, P> {
    /**
     * Returns the inverse of this lambda, which is also a bijection.
     *
     * @return inverse
     */
    public IBijection<P, R> getInverse();
}
