package model.length;

import model.AUnit;
import model.IBijection;

/**
 * Meter length unit.
 *
 * @author Mathias Ricken
 */
public class Meter extends AUnit<ILength> {
    public Meter() {
        super("m");
    }
    
    /**
     * Returns a function that converts a value in this length scale to a value in the "base length scale".
     * @return conversion function to "base scale"
     */
    protected IBijection<Double, Double> getConversionFunction() {
        // we chose to let our "base scale" coincide with the meter scale, so the conversion function
        // is just the identity function
        return new IBijection<Double, Double>() {
            public IBijection<Double, Double> getInverse() {
                return this; // this is the identity function
            }
            
            public Double apply(Double param) {
                return param; // this is the identity function
            }
        };
    }
}
