package model.length;

import model.AUnit;
import model.IBijection;

/**
 * Miles length unit.
 * @author Mathias Ricken
 */
public class Mile extends AUnit<ILength> {
    public Mile() {
        super("mi");
    }
    
    /**
     * Conversion function from Mile to base.
     */
    private final IBijection<Double, Double> _func = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _inverse;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param * 1609.344;
        }
    };
    
    /**
     * Conversion function from base to Mile.
     */
    private final IBijection<Double, Double> _inverse = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _func;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param / 1609.344;
        }
    };
    
    /**
     * Returns a function that converts a value in this length scale to a value in the "base length scale".
     * @return conversion function to "base scale"
     */
    protected IBijection<Double, Double> getConversionFunction() {
        // we chose to let our "base scale" coincide with the meter scale, so the conversion function
        // is the function from yards to meters, the inverse of the conversion function is the
        // function from meters to yards
        return _func;
    }
}
