package model.volume;

import model.AUnit;
import model.IBijection;

/**
 * Gallon volume unit.
 * @author Mathias Ricken
 */
public class Gallon extends AUnit<IVolume> {
    public Gallon() {
        super("gal");
    }
    
    /**
     * Conversion function from Gallon to base.
     */
    private final IBijection<Double, Double> _func = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _inverse;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param * 3.7854118;
        }
    };
    
    /**
     * Conversion function from base to Gallon.
     */
    private final IBijection<Double, Double> _inverse = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _func;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param / 3.7854118;
        }
    };
    
    /**
     * Returns a function that converts a value in this volume scale to a value in the "base volume scale".
     * @return conversion function to "base scale"
     */
    protected IBijection<Double, Double> getConversionFunction() {
        // we chose to let our "base scale" coincide with the meter scale, so the conversion function
        // is the function from yards to meters, the inverse of the conversion function is the
        // function from meters to yards
        return _func;
    }
}
