package model.volume;

import model.AUnit;
import model.IBijection;

/**
 * Liter volume unit.
 *
 * @author Mathias Ricken
 */
public class Liter extends AUnit<IVolume> {
    public Liter() {
        super("l");
    }
    
    /**
     * Returns a function that converts a value in this volume scale to a value in the "base volume scale".
     * @return conversion function to "base scale"
     */
    protected IBijection<Double, Double> getConversionFunction() {
        // we chose to let our "base scale" coincide with the liter scale, so the conversion function
        // is just the identity function
        return new IBijection<Double, Double>() {
            public IBijection<Double, Double> getInverse() {
                return this; // this is the identity function
            }
            
            public Double apply(Double param) {
                return param; // this is the identity function
            }
        };
    }
}
