package model.volume;

import model.AUnit;
import model.IBijection;

/**
 * Pint volume unit.
 * @author Mathias Ricken
 */
public class Pint extends AUnit<IVolume> {
    public Pint() {
        super("pints");
    }
    
    /**
     * Conversion function from Pints to base.
     */
    private final IBijection<Double, Double> _func = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _inverse;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param * 0.473176475;
        }
    };
    
    /**
     * Conversion function from base to Yard.
     */
    private final IBijection<Double, Double> _inverse = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _func;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param / 0.473176475;
        }
    };
    
    /**
     * Returns a function that converts a value in this volume scale to a value in the "base volume scale".
     * @return conversion function to "base scale"
     */
    protected IBijection<Double, Double> getConversionFunction() {
        // we chose to let our "base scale" coincide with the liter scale, so the conversion function
        // is the function from pints to liters, the inverse of the conversion function is the
        // function from liters to pints
        return _func;
    }
}
