package view;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowEvent;

/**
 * Conversion calculator frame.
 *
 * @author Mathias Ricken
 */
public class ConvCalcFrame extends JFrame {
    /**
     * Create a new conversion calculator frame.
     */
    public ConvCalcFrame() {
        super("Conversion Calculator");
        setLayout(new BorderLayout(1, 2));
        add(new ConvCalcView(), BorderLayout.CENTER);
        pack();
        Dimension screenSize;
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            screenSize = tk.getScreenSize();
        }
        catch (AWTError awe) {
            screenSize = new Dimension (640, 480);
        }
        Dimension frameSize = getSize();
        
        /* Fill screen if the screen is smaller that qtfSize. */
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        
        /* Center the screen */
        int x = screenSize.width/2 - frameSize.width/2;
        int y = screenSize.height/2 - frameSize.height/2;
        setLocation(x,y);
    }
    
    /**
     * Overridden so we can exit when window is closed.
     *
     * @param e event
     */
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (WindowEvent.WINDOW_CLOSING == e.getID()) {
            System.exit(0);
        }
    }
}
