package controller;

import model.IModelAdapter;
import model.TempCalcModel;
import view.TempCalcView;

import javax.swing.*;

/**
 * Main class for applet use.
 *
 * @author Mathias Ricken
 */
public class TempCalcApplet extends JApplet {
    /**
     * Initializes the applet - requred for all applets.
     */
    public void init() {
        try {
            final TempCalcModel model = new TempCalcModel();
            getContentPane().add(new TempCalcView(new IModelAdapter() {
                public double convertCtoF(double degreesCelsius) {
                    return model.convertCtoF(degreesCelsius);
                }
            }));
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
}
