package view;

import model.IModelAdapter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * Console view of the simple temperature calculator.
 *
 * @author Mathias Ricken
 */
public class TempCalcConsoleView {
    /**
     * Adapter to let the model perform computations.
     */
    private IModelAdapter _modelAdapter;
    
    /**
     * Buffered reader from standard in.
     */
    private BufferedReader _br = new BufferedReader(new InputStreamReader(System.in));
    
    /**
     * Constructs a new temperature calculator console view.
     *
     * @param modelAdapter adapter to model
     */
    public TempCalcConsoleView(IModelAdapter modelAdapter) {
        _modelAdapter = modelAdapter;
    }
    
    /**
     * Run the calculator.
     */
    public void run() {
        System.out.println("Convert temperature in Celsius to Fahrenheit.");
        String s;
        do {
            convertCtoF();
            System.out.println("Do you want to convert more temperatures? ");
            
            do {
                System.out.print("Press 'y' for yes, 'n' for no. ");
                try {
                    s = _br.readLine();
                }
                catch(IOException ioe) {
                    s = ""; // try again
                }
            } while((!s.equals("y")) && (!s.equals("n")));
        } while(s.equals("y"));
    }
    
    /**
     * Perform a temperature conversion from Celsius to Fahrenheit.
     */
    private void convertCtoF() {
        System.out.println();
        
        double d;
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Celsius: ");
            try {
                d = Double.valueOf(_br.readLine());
                System.out.println(String.valueOf(d)+" C = "+String.valueOf(_modelAdapter.convertCtoF(d))+" F");
                repeat = false;
            }
            catch(NumberFormatException nfe) {
                // nothing to do, just repeat
            }
            catch(IOException ioe) {
                // nothing to do, just repeat
            }
        } while(repeat);
    }
}
