package controller;

import model.IModelAdapter;
import model.TempCalcModel;
import view.TempCalcConsoleView;

/**
 * Main class for command-line use.
 *
 * @author Mathias Ricken
 */
public class TempCalcConsoleApp {
    /**
     * Entry point for Java VM.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        final TempCalcModel model = new TempCalcModel();
        (new TempCalcConsoleView(new IModelAdapter() {
            public double convertFtoC(double degreesFahrenheit) {
                return model.convertFtoC(degreesFahrenheit);
            }

            public double convertCtoF(double degreesCelsius) {
                return model.convertCtoF(degreesCelsius);
            }
        })).run();
    }
}
