package controller;

import model.AUnit;
import model.temperature.Celsius;
import view.IView;
import view.LauncherFrame;
import view.console.ConsoleView;
import view.gui.StandardView;

/**
 * Main class for command-line use.
 */
public class TempCalcApp {
    /**
     * Entry point for Java VM.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        java.util.ArrayList<AUnit> units = new java.util.ArrayList<AUnit>();
        units.add(new Celsius());
        //
        // TODO: add other units
        //

        IView[] views = new IView[] { new StandardView(units), new ConsoleView(units) };
        (new LauncherFrame(views, units)).setVisible(true);
    }
}
