package model;

import junit.framework.TestCase;

/**
 * A JUnit test case class for TempCalcModel.
 */
public class TempCalcModelTest extends TestCase {  
    /**
     * The model.
     */
    TempCalcModel _m;

    /**
     * Setup for test cases.
     */
    protected void setUp() throws Exception {
        super.setUp();
        _m = new TempCalcModel();
    }
    
    /**
     * Test method for C to F conversion.
     */
    public void testCtoF() {
        assertEquals(212.0,  _m.convertCtoF(100.0),  0.1);
        assertEquals(32.0,   _m.convertCtoF(0.0),    0.1);
        assertEquals(-148.0, _m.convertCtoF(-100.0), 0.1);
    }    
    
    /**
     * Test method for F to C conversion.
     */
    public void testFtoC() {
        assertEquals(100.0,  _m.convertFtoC(212.0),  0.1);
        assertEquals(0.0,    _m.convertFtoC(32.0),   0.1);
        assertEquals(-100.0, _m.convertFtoC(-148.0), 0.1);
    } 
    
    /**
     * Test method for C to K conversion.
     */
    public void testCtoK() {
        assertEquals(373.2, _m.convertCtoK(100.0),  0.1);
        assertEquals(273.2, _m.convertCtoK(0.0),    0.1);
        assertEquals(173.2, _m.convertCtoK(-100.0), 0.1);
    }    
    
    /**
     * Test method for K to C conversion.
     */
    public void testKtoC() {
        assertEquals(100.0,  _m.convertKtoC(373.2), 0.1);
        assertEquals(-273.2, _m.convertKtoC(0.0),   0.1);
        assertEquals(0.0,    _m.convertKtoC(273.2), 0.1);
    }
    
    /**
     * Test method for F to K conversion.
     */
    public void testFtoK() {
        assertEquals(373.2, _m.convertCtoK(_m.convertFtoC(212.0)),  0.1);
        assertEquals(273.2, _m.convertCtoK(_m.convertFtoC(32.0)),   0.1);
        assertEquals(173.2, _m.convertCtoK(_m.convertFtoC(-148.0)), 0.1);
    }    
    
    /**
     * Test method for K to F conversion.
     */
    public void testKtoF() {
        assertEquals(212.0,  _m.convertCtoF(_m.convertKtoC(373.2)), 0.1);
        assertEquals(-459.7, _m.convertCtoF(_m.convertKtoC(0.0)),   0.1);
        assertEquals(32.0,   _m.convertCtoF(_m.convertKtoC(273.2)), 0.1);
    }
}
