package view;

import model.IModelAdapter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * Console view of the simple temperature calculator.
 *
 * @author Mathias Ricken
 */
public class TempCalcConsoleView {
    /**
     * Adapter to let the model perform computations.
     */
    private IModelAdapter _modelAdapter;
    
    /**
     * Buffered reader from standard in.
     */
    private BufferedReader _br = new BufferedReader(new InputStreamReader(System.in));
    
    /**
     * Constructs a new temperature calculator console view.
     *
     * @param modelAdapter adapter to model
     */
    public TempCalcConsoleView(IModelAdapter modelAdapter) {
        _modelAdapter = modelAdapter;
    }
    
    /**
     * Run the calculator.
     */
    public void run() {
        System.out.println("Convert temperature between Celsius, Fahrenheit, and Kelvin.");
        String s;
        do {
            s = multipleChoice("Press 'c'/'f'/'k' to convert from Celsius, Fahrenheit, or Kelvin, respectively.", "c", "f", "k");
            if (s.equals("c")) {
                convertC();
            }
            else if (s.equals("f")) {
                convertF();
            }
            else {
                convertK();
            }
            System.out.println("Do you want to convert more temperatures? ");
            s = multipleChoice("Press 'y' for yes, 'n' for no.", "y", "n");
        } while(s.equals("y"));
    }
    
    /**
     * Ask user to pick one of multiple choices.
     * @param prompt prompt to display
     * @param choices varargs with different choices
     * @return selected choice
     */
    private String multipleChoice(String prompt, String... choices) {
        String s = null;
        boolean repeat = true;
        do {
            System.out.print(prompt+" ");
            try {
                s = _br.readLine();
            }
            catch(IOException ioe) {
                continue;
            }
            repeat = true;
            for(String c: choices) {
                if (c.equals(s)) {
                    repeat = false;
                    break;
                }
            }
        } while(repeat);
        return s;
    }
    
    /**
     * Perform a temperature conversion from Celsius to Fahrenheit and Kelvin.
     */
    private void convertC() {
        System.out.println();
        
        double d;
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Celsius: ");
            try {
                d = Double.valueOf(_br.readLine());
                System.out.println(String.valueOf(d)+" C = "+
                                   String.valueOf(_modelAdapter.convertCtoF(d))+" F = "+
                                   String.valueOf(_modelAdapter.convertCtoK(d))+" K");
                repeat = false;
            }
            catch(NumberFormatException nfe) {
                // nothing to do, just repeat
            }
            catch(IOException ioe) {
                // nothing to do, just repeat
            }
        } while(repeat);
    }
    
    /**
     * Perform a temperature conversion from Fahrenheit to Celsius and Kelvin.
     */
    private void convertF() {
        System.out.println();
        
        double d;
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Fahrenheit: ");
            try {
                d = Double.valueOf(_br.readLine());
                System.out.println(String.valueOf(d)+" F = "+
                                   String.valueOf(_modelAdapter.convertFtoC(d))+" C = "+
                                   String.valueOf(_modelAdapter.convertCtoK(_modelAdapter.convertFtoC(d)))+" K");
                repeat = false;
            }
            catch(NumberFormatException nfe) {
                // nothing to do, just repeat
            }
            catch(IOException ioe) {
                // nothing to do, just repeat
            }
        } while(repeat);
    }
    
    
    /**
     * Perform a temperature conversion from Kelvin to Celsius and Fahrenheit.
     */
    private void convertK() {
        System.out.println();
        
        double d;
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Kelvin: ");
            try {
                d = Double.valueOf(_br.readLine());
                System.out.println(String.valueOf(d)+" K = "+
                                   String.valueOf(_modelAdapter.convertKtoC(d))+" C = "+
                                   String.valueOf(_modelAdapter.convertCtoF(_modelAdapter.convertKtoC(d)))+" F");
                repeat = false;
            }
            catch(NumberFormatException nfe) {
                // nothing to do, just repeat
            }
            catch(IOException ioe) {
                // nothing to do, just repeat
            }
        } while(repeat);
    }
}
