package controller;

import model.IModelAdapter;
import model.TempCalcModel;
import view.TempCalcConsoleView;

/**
 * Main class for command-line use.
 *
 * @author Mathias Ricken
 */
public class TempCalcConsoleApp {
    /**
     * Entry point for Java VM.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) {
        final TempCalcModel model = new TempCalcModel();
        (new TempCalcConsoleView(new IModelAdapter() {
            public double convertFtoC(double degreesFahrenheit) {
                return model.convertFtoC(degreesFahrenheit);
            }

            public double convertCtoF(double degreesCelsius) {
                return model.convertCtoF(degreesCelsius);
            }

            public double convertCtoK(double degreesCelsius) {
                return model.convertCtoK(degreesCelsius);
            }

            public double convertKtoC(double kelvin) {
                return model.convertKtoC(kelvin);
            }
            
            public double convertFtoK(double degreesFahrenheit) {
                return model.convertFtoK(degreesFahrenheit);
            }

            public double convertKtoF(double kelvin) {
                return model.convertKtoF(kelvin);
            }
        })).run();
    }
}
