package model;

/**
 * Abstract unit class.
 *
 * @author Mathias Ricken
 */
public abstract class AUnit {
    /**
     * Unit symbol.
     */
    protected String _unitSymbol;
    
    /**
     * Returns a function that converts a value in these units to a value in "base units".
     *
     * @return conversion function to "base scale"
     */
    protected abstract IBijection<Double, Double> getConversionFunction();
    
    /**
     * Returns a string representation of this currency, i.e. the symbol.
     *
     * @return string representation
     */
    public String toString() {
        return _unitSymbol;
    }
    
    /**
     * Constructor for an abstract unit.
     *
     * @param unitSymbol unit symbol
     */
    protected AUnit(String unitSymbol) {
        _unitSymbol = unitSymbol;
    }
    
    /**
     * Converts a measurement in some unit to a measurement in this unit.
     *
     * @param m measurement in some unit
     *
     * @return measurement in this unit
     */
    public Measurement convertTo(Measurement m) {
        double amount = m.getValue();
        double amountInBase = m.getUnit().getConversionFunction().apply(amount);
        double amountInThis = getConversionFunction().getInverse().apply(amountInBase);
        return new Measurement(amountInThis, this);
    }
}
