package model.temperature;

import model.AUnit;
import model.IBijection;

/**
 * Kelvin temperature unit.
 *
 * @author Mathias Ricken
 */
public class Kelvin extends AUnit {
    public Kelvin() {
        super("K");
    }
    
    /**
     * Conversion function from Kelvin to base.
     */
    private final IBijection<Double, Double> _func = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _inverse;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param - 273.2;
        }
    };
    
    /**
     * Conversion function from base to Kelvin.
     */
    private final IBijection<Double, Double> _inverse = new IBijection<Double, Double>() {
        /**
         * Returns the inverse of this lambda, which is also a bijection.
         *
         * @return inverse
         */
        public IBijection<Double, Double> getInverse() {
            return _func;
        }
        
        /**
         * Apply the lambda.
         *
         * @param param lambda-specific parameter
         *
         * @return lambda-specific return value
         */
        public Double apply(Double param) {
            return param + 273.2;
        }
    };
    
    /**
     * Returns a function that converts a value in this temperature scale to a value in the "base temperature scale".
     *
     * @return conversion function to "base scale"
     */
    protected IBijection<Double, Double> getConversionFunction() {
        // we chose to let our "base scale" coincide with the Celsius scale, so the conversion function
        // is the function from Kelvin to Celsius, the inverse of the conversion function is the
        // function from Celsius to Kelvin
        return _func;
    }
}
