package view;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Dialog to enter a string.
 *
 * @author Mathias Ricken
 */
public class InputStringDialog {
    private JDialog _dialog;
    
    private JTextField _textField;
    
    /**
     * Creates a new input string dialog and all its controls.
     *
     * @param parent parent dialog for the dialog
     * @param title  window title
     */
    public InputStringDialog(JDialog parent, String title) {
        _dialog = new JDialog(parent, title, true);
        _dialog.setContentPane(makeOptionsPanel());
        _dialog.pack();
        _dialog.setResizable(false);
    }
    
    /**
     * Creates a new input string dialog and all its controls.
     *
     * @param parent parent frame for the dialog
     * @param title  window title
     */
    public InputStringDialog(Frame parent, String title) {
        _dialog = new JDialog(parent, title, true);
        _dialog.setContentPane(makeOptionsPanel());
        _dialog.pack();
        _dialog.setResizable(false);
    }
    
    /**
     * Show the modal dialog.
     *
     * @return contents of text field
     */
    public String showDialog() {
        // center dialog in middle of parent frame
        Component parent = _dialog.getParent();
        _dialog.setLocation(parent.getX() + parent.getWidth() / 2 - _dialog.getSize().width / 2,
                            parent.getY()
                                + parent.getHeight()
                                / 2
                                - _dialog
                                .getSize().height
                                / 2);
        _dialog.setVisible(true); // Modal dialog will block until setVisible(false), see ok/cancel methods
        return _textField.getText();
    }
    
    // callback when user clicks cancel button
    private void cancelClicked() {
        _textField.setText("");
        _dialog.setVisible(false);
    }
    
    // callback when user clicks ok button
    private void okClicked() {
        _dialog.setVisible(false);
    }
    
    /**
     * Build options dialog.
     *
     * @return options pane
     */
    private JOptionPane makeOptionsPanel() {
        JPanel myControls = new JPanel();
        myControls.setLayout(new BoxLayout(myControls, BoxLayout.Y_AXIS));
        _textField = new JTextField();
        myControls.add(_textField);
        JOptionPane optPane = new JOptionPane(myControls, JOptionPane.QUESTION_MESSAGE);
        JButton[] optButtons = new JButton[]{new JButton("Create"), new JButton("Cancel")};
        optPane.setOptions(optButtons);
        optPane.setInitialValue(optButtons[0]);
        optButtons[1].addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cancelClicked();
            }
        });
        optButtons[0].addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                okClicked();
            }
        });
        return optPane;
    }
}


