package model;

/**
 * Measurement class.
 *
 * @author Mathias Ricken
 */
public class Measurement {
    /**
     * Unit of this measurement.
     */
    AUnit _unit;
    
    /**
     * Value of this measurement.
     */
    double _value;
    
    /**
     * Constructor for a measurement.
     *
     * @param value value of this measurement
     * @param unit  unit of this measurement
     */
    public Measurement(double value, AUnit unit) {
        _unit = unit;
        _value = value;
    }
    
    /**
     * Returns the unit of this measurement.
     *
     * @return unit
     */
    public AUnit getUnit() {
        return _unit;
    }
    
    /**
     * Returns the value of this measurement.
     * @return value
     */
    public double getValue() {
        return _value;
    }
    
    /**
     * Returns the string representation: <number> <unit>
     * @return string representation
     */
    public String toString() {
        return String.valueOf(_value)+" "+_unit.toString();
    }
    
    /**
     * Returns true if the two objects are equal.
     * @return true if equal
     */
    public boolean equals(Object other) {
        return (other instanceof Measurement) &&
            (_value == ((Measurement)other)._value) &&
            (_unit.equals(((Measurement)other)._unit));
    }
}
