package view;

import model.AUnit;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;

/**
 * Launcher frame.
 *
 * @author Mathias Ricken
 */
public class LauncherFrame extends JFrame {

    /**
     * Create a new temperature calculator launcher frame.
     * @param views list of views
     * @param units list of units
     */
    public LauncherFrame(IView[] views, List<AUnit> units) {
        super("Temperature Calculator Launcher");
        if (units.size()<2) {
            throw new IllegalArgumentException("Need at least two units.");
        }

        setLayout(new GridLayout(0, 1));
        add(new JLabel("Please select view:"));
        for(IView v: views) {
            addViewButton(v);
        }
        pack();
        Dimension screenSize;
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            screenSize = tk.getScreenSize();
        }
        catch (AWTError awe) {
            screenSize = new Dimension (640, 480);
        }
        Dimension frameSize = getSize();
        
        /* Fill screen if the screen is smaller that qtfSize. */
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        
        /* Center the screen */
        int x = screenSize.width/2 - frameSize.width/2;
        int y = screenSize.height/2 - frameSize.height/2;
        setLocation(x,y);
    }

    /**
     * Overridden so we can exit when window is closed.
     *
     * @param e event
     */
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (WindowEvent.WINDOW_CLOSING == e.getID()) {
            System.exit(0);
        }
    }
    
    /**
     * Add a button for the given view.
     * @param v view to add
     */
    private void addViewButton(final IView v) {
        JButton button = new JButton(v.getClass().getName());
        button.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                final SwingWorker worker = new SwingWorker() {
                    public Object construct() {
                        v.run();
                        return null;
                    }
                };
                worker.start();
            }
        });
        add(button);
    }
}
