/*
 * Decompiled with CFR 0.152.
 */
package model.fish.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import sysModel.fish.IFishDisplay;

public class ImageFishDisplay
implements IFishDisplay {
    private ImageIcon _icon;
    private Image _originalImage;
    private double _radians;
    private HashMap _tintedVersions = new HashMap();

    public ImageFishDisplay(String imageFilename, double radians) {
        URL urlInJarFile = this.getClass().getResource(imageFilename);
        if (urlInJarFile != null) {
            this._icon = new ImageIcon(urlInJarFile);
        } else {
            String path = System.getProperty("user.dir") + File.separator + imageFilename;
            this._icon = new ImageIcon(path);
        }
        this._radians = radians;
        this._originalImage = this._icon.getImage();
    }

    public void draw(Graphics2D g, Component comp, Color fishColor) {
        if (this._icon.getImageLoadStatus() != 8) {
            g.setPaint(fishColor);
            g.fill(new Ellipse2D.Double(-0.4, -0.4, 0.8, 0.8));
            return;
        }
        g.rotate(this._radians);
        g.scale(1.0 / (double)this._icon.getIconWidth(), 1.0 / (double)this._icon.getIconHeight());
        Image tinted = (Image)this._tintedVersions.get(fishColor);
        if (tinted == null) {
            FilteredImageSource src = new FilteredImageSource(this._originalImage.getSource(), new TintFilter(fishColor));
            tinted = comp.createImage(src);
            this._tintedVersions.put(fishColor, tinted);
        }
        this._icon.setImage(tinted);
        this._icon.paintIcon(comp, g, -this._icon.getIconWidth() / 2, -this._icon.getIconHeight() / 2);
    }

    private static class TintFilter
    extends RGBImageFilter {
        private int tintR;
        private int tintG;
        private int tintB;

        public TintFilter(Color color) {
            this.canFilterIndexColorModel = true;
            int rgb = color.getRGB();
            this.tintR = rgb >> 16 & 0xFF;
            this.tintG = rgb >> 8 & 0xFF;
            this.tintB = rgb & 0xFF;
        }

        public int filterRGB(int x, int y, int argb) {
            int alpha = argb >> 24 & 0xFF;
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            int lum = (int)(0.2989 * (double)red + 0.5866 * (double)green + 0.1144 * (double)blue);
            double scale = Math.abs((double)(lum - 128) / 128.0);
            int edge = lum < 128 ? 0 : 255;
            red = this.tintR + (int)((double)(edge - this.tintR) * scale);
            green = this.tintG + (int)((double)(edge - this.tintG) * scale);
            blue = this.tintB + (int)((double)(edge - this.tintB) * scale);
            return alpha << 24 | red << 16 | green << 8 | blue;
        }
    }
}

