/*
 * Decompiled with CFR 0.152.
 */
package model.fish.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import sysModel.fish.IFishDisplay;

public class ParamFishDisplay
implements IFishDisplay {
    private static final double BODY_WIDTH = 0.55;
    private static final double BODY_LENGTH = 0.75;
    private static final double TAIL_WIDTH = 0.5;
    private static final double TAIL_LENGTH = 0.4;
    private static final double EYE_SIZE = 0.08;
    private static final int GRADIENT_SIZE = 50;
    private static final AffineTransform ATX = AffineTransform.getScaleInstance(50.0, 50.0);
    private Shape bodyAndTail;
    private Shape eye1;
    private Shape eye2;

    public ParamFishDisplay(double bodyWidth, double bodyLength, double tailWidth, double tailLength, double eyeSize) {
        this.buildPaths(bodyWidth, bodyLength, tailWidth, tailLength, eyeSize);
    }

    public ParamFishDisplay() {
        this(0.55, 0.75, 0.5, 0.4, 0.08);
    }

    private void buildPaths(double bodyWidth, double bodyLength, double tailWidth, double tailLength, double eyeSize) {
        float halfFishLength = (float)(bodyLength + tailLength / 3.0) / 2.0f;
        Ellipse2D.Double body = new Ellipse2D.Double(-bodyWidth / 2.0, -halfFishLength, bodyWidth, bodyLength);
        GeneralPath tail = new GeneralPath();
        tail.moveTo(-((float)tailWidth) / 2.0f, halfFishLength);
        tail.lineTo(0.0f, halfFishLength - (float)tailLength);
        tail.lineTo((float)tailWidth / 2.0f, halfFishLength);
        tail.closePath();
        tail.append(body, false);
        this.bodyAndTail = tail;
        this.eye1 = new Ellipse2D.Double(-bodyWidth / 4.0, (double)(-halfFishLength) + bodyLength / 4.0, eyeSize, eyeSize);
        this.eye2 = new Ellipse2D.Double(bodyWidth / 4.0 - eyeSize, (double)(-halfFishLength) + bodyLength / 4.0, eyeSize, eyeSize);
    }

    public void draw(Graphics2D g2, Component comp, Color fishColor) {
        Color oldColor = g2.getColor();
        g2.setPaint(fishColor.darker());
        g2.draw(this.bodyAndTail);
        g2.scale(0.02, 0.02);
        g2.setPaint(new GradientPaint(-12.0f, -25.0f, Color.white, 12.0f, 12.0f, fishColor));
        g2.fill(ATX.createTransformedShape(this.bodyAndTail));
        g2.scale(50.0, 50.0);
        g2.setPaint(Color.black);
        g2.fill(this.eye1);
        g2.fill(this.eye2);
        g2.setColor(oldColor);
    }
}

