/*
 * Decompiled with CFR 0.152.
 */
package sysModel;

import controller.IEditAdapter;
import controller.IScrollAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Timer;
import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.NoOpLambda;
import sysModel.SimEngine;
import sysModel.env.AEnvFactory;
import sysModel.env.AGlobalEnv;
import sysModel.env.FishApplyParams;
import sysModel.env.ILocalEnv;
import sysModel.env.NullEnv;
import sysModel.fish.AFish;
import sysModel.fish.DynamicFishFactory;
import sysModel.parser.Parser;
import sysModel.parser.ParserException;

public class SimDriver {
    private AGlobalEnv _env;
    private SimEngine _simEngine;
    private ILambda _seedCommand;
    private ILambda _startCommand;
    private ILambda _iterationCommand;
    private int _simulationSpeed;
    private Timer _timer;
    private IEditAdapter _editAdapter = null;
    private ICmdFactory _cmdFactory = new ICmdFactory(){

        public ILambda makeNotifyCmd(ILambda lambda) {
            return new ILambda(this, lambda){
                private final /* synthetic */ ILambda val$lambda;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$lambda = val$lambda;
                }

                public Object apply(Object param) {
                    SimDriver.access$100(1.access$000(this.this$1)).notify(this.val$lambda);
                    return null;
                }
            };
        }

        public ILambda makeDeleteCmd(ILocalEnv env) {
            return this.makeNotifyCmd(new ILambda(this, env){
                private final /* synthetic */ ILocalEnv val$env;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$env = val$env;
                }

                public Object apply(Object param) {
                    FishApplyParams applyParams = (FishApplyParams)param;
                    if (applyParams.localEnv() == this.val$env) {
                        SimDriver.access$100(1.access$000(this.this$1)).delete(applyParams.fish());
                    }
                    return null;
                }
            });
        }

        public ILambda makeAddCmd(AFish fish) {
            return new ILambda(this, fish){
                private final /* synthetic */ AFish val$fish;
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = this$1;
                    this.val$fish = val$fish;
                }

                public Object apply(Object param) {
                    SimDriver.access$100(1.access$000(this.this$1)).add(this.val$fish);
                    return null;
                }
            };
        }

        static /* synthetic */ SimDriver access$000(1 x0) {
            return x0.SimDriver.this;
        }
    };

    public SimDriver() {
        this._env = NullEnv.instance();
        this._simEngine = new SimEngine();
        this._seedCommand = NoOpLambda.instance();
        this._startCommand = NoOpLambda.instance();
        this._iterationCommand = NoOpLambda.instance();
    }

    public ICmdFactory getCmdFactory() {
        return this._cmdFactory;
    }

    public void setAdapters(IEditAdapter ea) {
        this._editAdapter = ea;
    }

    public boolean loadEnvironment(String filename) {
        try {
            this._simEngine.clear();
            this._env = Parser.parse(filename, this._cmdFactory);
            this._seedCommand.apply(null);
            return true;
        }
        catch (ParserException e) {
            System.out.println(e);
            return false;
        }
    }

    public boolean saveEnvironment(String filename) {
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(filename));
            ILambda lambda = this._env.save(pw);
            this._simEngine.notify(lambda);
            pw.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean createEnvironment(AEnvFactory factory) {
        this._env = factory.create();
        this._simEngine.clear();
        this._seedCommand.apply(null);
        return true;
    }

    public void setSeedLambda(ILambda seedCmd) {
        this._seedCommand = seedCmd;
    }

    public void step() {
        ILambda lambda = this._env.makeStepCmd();
        lambda.apply(this);
    }

    public void start() {
        this._startCommand.apply(null);
        this._timer = new Timer(this._simulationSpeed, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimDriver.this.step();
                SimDriver.this._iterationCommand.apply(null);
            }
        });
        this._timer.start();
    }

    public void stop() {
        if (this._timer != null) {
            this._timer.stop();
        }
    }

    public void setSpeed(int speed) {
        this._simulationSpeed = speed;
        if (this._timer != null) {
            this._timer.setDelay(speed);
        }
    }

    public void setStartLambda(ILambda startCmd) {
        this._startCommand = startCmd;
    }

    public void setIterationLambda(ILambda itCmd) {
        this._iterationCommand = itCmd;
    }

    public void draw(Graphics2D g, Component comp, Point2D.Double p1, Point2D.Double p2) {
        ILambda lambda = this._env.makeDrawCmd(g, comp, p1, p2);
        lambda.apply(this);
    }

    public void edit(Point2D.Double p, int button) {
        DynamicFishFactory fishFactory = new DynamicFishFactory(this._editAdapter.getCurrentFish(), this._editAdapter.getCurrentColor());
        ILambda lambda = this._env.makeEditCmd(p, fishFactory, button);
        lambda.apply(this);
    }

    public void returnHome(IScrollAdapter sa) {
        this._env.returnHome(sa);
    }

    public Dimension getDisplaySize() {
        return this._env.getDisplaySize();
    }

    public Point2D.Double getViewPosition(Point2D.Double pos) {
        return this._env.getViewPosition(pos);
    }

    public Point2D.Double getPanDelta(Point2D.Double delta) {
        return this._env.getPanDelta(delta);
    }

    public String getToolTipText(Point2D.Double p) {
        return (String)this._env.getToolTipText(p).apply(this);
    }

    static /* synthetic */ SimEngine access$100(SimDriver x0) {
        return x0._simEngine;
    }
}

