/*
 * Decompiled with CFR 0.152.
 */
package sysModel.env;

import controller.IScrollAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import lrs.LRStruct;
import lrs.visitor.Apply;
import lrs.visitor.Clear;
import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.env.AEnvFactory;
import sysModel.env.DeactivatableLambda;
import sysModel.env.EmptyLocalEnvState;
import sysModel.env.FishApplyParams;
import sysModel.env.ILocalEnv;
import sysModel.env.NonEmptyLocalEnvState;
import sysModel.fish.AFish;
import sysModel.fish.IFishFactory;
import sysModel.parser.Lexer;

public abstract class AGlobalEnv {
    protected static final Color OCEAN_BLUE = new Color(75, 75, 255);
    protected LRStruct _moveLambdas;
    protected LRStruct _breedLambdas;
    protected ICmdFactory _cmdFactory;
    protected Color _waterColor = OCEAN_BLUE;

    public AGlobalEnv(ICmdFactory cmdFactory) {
        this._breedLambdas = new LRStruct();
        this._moveLambdas = new LRStruct();
        this._cmdFactory = cmdFactory;
    }

    protected void deactivateMoveLambdas() {
        this._moveLambdas.execute(Apply.Singleton, new ILambda(){

            public Object apply(Object param) {
                DeactivatableLambda cmd = (DeactivatableLambda)param;
                cmd.deactivate();
                return null;
            }
        });
        this._moveLambdas.execute(Clear.Singleton, null);
    }

    protected void deactivateBreedLambdas() {
        this._breedLambdas.execute(Apply.Singleton, new ILambda(){

            public Object apply(Object param) {
                DeactivatableLambda cmd = (DeactivatableLambda)param;
                cmd.deactivate();
                return null;
            }
        });
        this._breedLambdas.execute(Clear.Singleton, null);
    }

    public ILambda makeEditCmd(Point2D.Double p, final IFishFactory fishFactory, final int button) {
        final ILocalEnv localEnv = this.makeLocalEnv(p);
        return (ILambda)localEnv.execute(new ILocalEnvVisitor(){

            public Object emptyCase(ILocalEnv host, Object param) {
                return AGlobalEnv.this.addFish(localEnv, fishFactory.createFish());
            }

            public Object nonEmptyCase(ILocalEnv host, Object param) {
                return AGlobalEnv.this.editFish(host, fishFactory, button);
            }
        }, null);
    }

    protected ILambda addFish(ILocalEnv localEnv, AFish fish) {
        localEnv.setState(NonEmptyLocalEnvState.Singleton);
        fish.setLocalEnvironment(localEnv);
        this.addFishToInternalData(localEnv, fish);
        return this._cmdFactory.makeAddCmd(fish);
    }

    protected void removeFish(ILocalEnv localEnv) {
        localEnv.setState(EmptyLocalEnvState.Singleton);
        this.removeFishFromInternalData(localEnv);
    }

    public ILambda makeDrawCmd(final Graphics2D g2, final Component comp, final Point2D.Double p1, Point2D.Double p2) {
        this.drawBackground(g2, p1, p2);
        return this._cmdFactory.makeNotifyCmd(new ILambda(){

            public Object apply(Object param) {
                AffineTransform oldTransform = g2.getTransform();
                g2.translate(-((int)Math.floor(p1.x)), -((int)Math.floor(p1.y)));
                ((FishApplyParams)param).fish().draw(g2, comp);
                g2.setTransform(oldTransform);
                return null;
            }
        });
    }

    protected void drawBackground(Graphics2D g2, Point2D.Double p1, Point2D.Double p2) {
        g2.setColor(this._waterColor);
        g2.fillRect(0, 0, (int)(p2.x - p1.x), (int)(p2.y - p1.y));
        g2.setColor(Color.black);
        int y = 0;
        while ((double)y <= p2.y - p1.y) {
            g2.drawLine(0, y, (int)(p2.x - p1.x), y);
            ++y;
        }
        int x = 0;
        while ((double)x <= p2.x - p1.x) {
            g2.drawLine(x, 0, x, (int)(p2.y - p1.y));
            ++x;
        }
    }

    public ILambda makeStepCmd() {
        return this._cmdFactory.makeNotifyCmd(new ILambda(){

            public Object apply(Object param) {
                AGlobalEnv.this.deactivateBreedLambdas();
                AGlobalEnv.this.deactivateMoveLambdas();
                ((FishApplyParams)param).fish().act();
                return null;
            }
        });
    }

    public ILambda save(final PrintWriter pw) {
        this.printHeader(pw);
        return this._cmdFactory.makeNotifyCmd(new ILambda(){

            public Object apply(Object param) {
                pw.println(param);
                return null;
            }
        });
    }

    public AGlobalEnv parse(Lexer l) {
        AGlobalEnv env = this.parseEnvironment(l);
        env.parseFish(l);
        return env;
    }

    protected abstract ILambda editFish(ILocalEnv var1, IFishFactory var2, int var3);

    protected abstract void addFishToInternalData(ILocalEnv var1, AFish var2);

    protected abstract void removeFishFromInternalData(ILocalEnv var1);

    protected abstract AGlobalEnv parseEnvironment(Lexer var1);

    protected abstract void parseFish(Lexer var1);

    protected abstract ILocalEnv makeLocalEnv(Point2D.Double var1);

    public abstract AEnvFactory makeEnvFactory();

    protected abstract void printHeader(PrintWriter var1);

    public abstract Dimension getDisplaySize();

    public abstract void returnHome(IScrollAdapter var1);

    public abstract Point2D.Double getViewPosition(Point2D.Double var1);

    public abstract Point2D.Double getPanDelta(Point2D.Double var1);

    public abstract ILambda getToolTipText(Point2D.Double var1);

    public static interface ILocalEnvVisitor {
        public Object emptyCase(ILocalEnv var1, Object var2);

        public Object nonEmptyCase(ILocalEnv var1, Object var2);
    }

    protected class BreedLambda
    implements ILambda {
        private final AFish _fish;
        private final ILocalEnv _newLocalEnv;

        public BreedLambda(AFish fish, ILocalEnv newLocalEnv) {
            this._fish = fish;
            this._newLocalEnv = newLocalEnv;
        }

        public Object apply(Object param) {
            AFish clone = (AFish)this._fish.clone();
            AGlobalEnv.this.addFish(this._newLocalEnv, clone);
            AGlobalEnv.this.deactivateBreedLambdas();
            return null;
        }
    }
}

