/*
 * Decompiled with CFR 0.152.
 */
package sysModel.env;

import controller.IScrollAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import model.ILambda;
import model.RandNumGenerator;
import sysModel.ICmdFactory;
import sysModel.NoOpLambda;
import sysModel.env.AEnvFactory;
import sysModel.env.AGlobalEnv;
import sysModel.env.ASquareEnv;
import sysModel.env.FishApplyParams;
import sysModel.env.ILocalEnv;
import sysModel.fish.AFish;
import sysModel.fish.IFishFactory;
import sysModel.parser.DefaultTokenVisitor;
import sysModel.parser.Lexer;
import sysModel.parser.ParserException;

public abstract class ASquareEnv
extends AGlobalEnv {
    static /* synthetic */ Class class$java$awt$Color;

    public ASquareEnv(ICmdFactory cmdFactory) {
        super(cmdFactory);
    }

    protected abstract void addFishToInternalData(ILocalEnv var1, AFish var2);

    public ILambda editFish(ILocalEnv le, IFishFactory fishFactory, int button) {
        ILambda lambdaForControl = NoOpLambda.instance();
        ISquareLocalEnvironment localEnv = (ISquareLocalEnvironment)le;
        if (button == 1) {
            double initialAngle = localEnv.direction().getAngle();
            localEnv.direction().turnRight(1.5707963267948966);
            if (initialAngle > localEnv.direction().getAngle()) {
                lambdaForControl = this._cmdFactory.makeDeleteCmd(localEnv);
                this.removeFish(le);
            }
        }
        return lambdaForControl;
    }

    public ILocalEnv makeLocalEnv(Point2D.Double p) {
        return this.makeLocalEnv(this.makeLocation(p.getX(), p.getY()), this.makeDirection());
    }

    protected abstract ISquareLocalEnvironment makeLocalEnv(Location var1, Direction var2);

    protected abstract AGlobalEnv parseEnvironment(Lexer var1);

    protected void parseFish(final Lexer l) {
        while (l.nextToken().execute(new DefaultTokenVisitor(){

            public Object defaultCase() {
                throw new ParserException("Invalid token");
            }

            public Object endCase() {
                return Boolean.FALSE;
            }

            public Object wordCase(String className) {
                try {
                    Class<?> fishClass = Class.forName(className);
                    Constructor<?> fishCtor = fishClass.getConstructor(class$java$awt$Color == null ? (class$java$awt$Color = ASquareEnv.class$("java.awt.Color")) : class$java$awt$Color);
                    RandNumGenerator rng = RandNumGenerator.instance();
                    AFish fish = (AFish)fishCtor.newInstance(new Color(rng.nextInt(256), rng.nextInt(256), rng.nextInt(256)));
                    Location loc = new Location().parse(l);
                    Direction dir = new Direction().parse(l);
                    ISquareLocalEnvironment localEnv = ASquareEnv.this.makeLocalEnv(loc, dir);
                    ILambda addLambda = ASquareEnv.this.addFish(localEnv, fish);
                    addLambda.apply(null);
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ParserException(e.toString());
                }
            }
        }) == Boolean.TRUE) {
        }
    }

    public abstract AEnvFactory makeEnvFactory();

    protected abstract void printHeader(PrintWriter var1);

    public abstract Dimension getDisplaySize();

    public abstract void returnHome(IScrollAdapter var1);

    public abstract Point2D.Double getViewPosition(Point2D.Double var1);

    public abstract Point2D.Double getPanDelta(Point2D.Double var1);

    public ILambda getToolTipText(final Point2D.Double p) {
        final ISquareLocalEnvironment l = (ISquareLocalEnvironment)this.makeLocalEnv(p);
        return (ILambda)l.execute(new AGlobalEnv.ILocalEnvVisitor(){

            public Object emptyCase(ILocalEnv host, Object param) {
                return new ILambda(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object apply(Object param) {
                        return "(" + (int)Math.floor(2.access$000(this.this$1).x) + "," + (int)Math.floor(2.access$000(this.this$1).y) + ") is empty";
                    }
                };
            }

            public Object nonEmptyCase(ILocalEnv host, Object param) {
                return new ILambda(this){
                    String _fishName;
                    ILocalEnv _localEnv;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object apply(Object param) {
                        this._fishName = "";
                        2.access$300(this.this$1)._cmdFactory.makeNotifyCmd(new ILambda(this){
                            private final /* synthetic */ 4 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public Object apply(Object param) {
                                FishApplyParams fap = (FishApplyParams)param;
                                if (((ISquareLocalEnvironment)fap.localEnv()).location().inField(2.access$200(4.access$100(this.this$2)).location())) {
                                    this.this$2._fishName = fap.fish().toString();
                                    this.this$2._localEnv = fap.localEnv();
                                }
                                return null;
                            }
                        }).apply(null);
                        return this._fishName + " at " + this._localEnv;
                    }

                    static /* synthetic */ 2 access$100(4 x0) {
                        return x0.this$1;
                    }
                };
            }

            static /* synthetic */ Point2D.Double access$000(2 x0) {
                return x0.p;
            }

            static /* synthetic */ ISquareLocalEnvironment access$200(2 x0) {
                return x0.l;
            }

            static /* synthetic */ ASquareEnv access$300(2 x0) {
                return x0.ASquareEnv.this;
            }
        }, null);
    }

    public Direction makeDirection() {
        return new Direction();
    }

    public Direction makeDirection(double dx, double dy) {
        return new Direction(dx, dy);
    }

    public Direction makeDirection(Direction other) {
        return new Direction(other);
    }

    public Location makeLocation(double x, double y) {
        return new Location(x, y);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface ISquareLocalEnvironment
    extends ILocalEnv {
        public Location location();

        public Direction direction();
    }

    public class Location {
        private double _x;
        private double _y;

        public double getX() {
            return this._x;
        }

        public double getY() {
            return this._y;
        }

        public void setX(double _x) {
            this._x = _x;
        }

        public void setY(double _y) {
            this._y = _y;
        }

        public Location() {
            this._x = 0.0;
            this._y = 0.0;
        }

        public Location(double x, double y) {
            this._x = x;
            this._y = y;
        }

        public boolean same(Location other) {
            return this._x == other.getX() && this._y == other.getY();
        }

        public boolean inField(Location other) {
            return Math.floor(other.getX()) == Math.floor(this.getX()) && Math.floor(other.getY()) == Math.floor(this.getY());
        }

        public Location getNeighbor(Direction dir) {
            return ASquareEnv.this.makeLocation(this._x + dir.getDeltaX(), this._y + dir.getDeltaY());
        }

        public String toString() {
            return "(" + (int)Math.floor(this._x) + ", " + (int)Math.floor(this._y) + ")";
        }

        public Location parse(Lexer l) {
            return (Location)l.nextToken().execute(new DefaultTokenVisitor(this, l){
                private final /* synthetic */ Lexer val$l;
                private final /* synthetic */ Location this$1;
                {
                    this.this$1 = this$1;
                    this.val$l = val$l;
                }

                public Object defaultCase() {
                    throw new ParserException("Invalid token");
                }

                public Object openCase() {
                    return this.val$l.nextToken().execute(new DefaultTokenVisitor(this){
                        private final /* synthetic */ 11 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public Object defaultCase() {
                            throw new ParserException("Invalid token");
                        }

                        public Object numCase(double x) {
                            return 11.access$1700(this.this$2).nextToken().execute(new DefaultTokenVisitor(this, x){
                                private final /* synthetic */ double val$x;
                                private final /* synthetic */ 12 this$3;
                                {
                                    this.this$3 = this$3;
                                    this.val$x = val$x;
                                }

                                public Object defaultCase() {
                                    throw new ParserException("Invalid token");
                                }

                                public Object commaCase() {
                                    return 11.access$1700(12.access$1400(this.this$3)).nextToken().execute(new DefaultTokenVisitor(this){
                                        private final /* synthetic */ 13 this$4;
                                        {
                                            this.this$4 = this$4;
                                        }

                                        public Object defaultCase() {
                                            throw new ParserException("Invalid token");
                                        }

                                        public Object numCase(double y) {
                                            return 11.access$1700(12.access$1400(13.access$1300(this.this$4))).nextToken().execute(new DefaultTokenVisitor(this, y){
                                                private final /* synthetic */ double val$y;
                                                private final /* synthetic */ 14 this$5;
                                                {
                                                    this.this$5 = this$5;
                                                    this.val$y = val$y;
                                                }

                                                public Object defaultCase() {
                                                    throw new ParserException("Invalid token");
                                                }

                                                public Object closeCase() {
                                                    return Location.access$1600(11.access$1500(12.access$1400(13.access$1300(14.access$1100(this.this$5))))).makeLocation(13.access$1200(14.access$1100(this.this$5)), this.val$y);
                                                }
                                            });
                                        }

                                        static /* synthetic */ 13 access$1100(14 x0) {
                                            return x0.this$4;
                                        }
                                    });
                                }

                                static /* synthetic */ double access$1200(13 x0) {
                                    return x0.val$x;
                                }

                                static /* synthetic */ 12 access$1300(13 x0) {
                                    return x0.this$3;
                                }
                            });
                        }

                        static /* synthetic */ 11 access$1400(12 x0) {
                            return x0.this$2;
                        }
                    });
                }

                static /* synthetic */ Location access$1500(11 x0) {
                    return x0.this$1;
                }

                static /* synthetic */ Lexer access$1700(11 x0) {
                    return x0.val$l;
                }
            });
        }

        static /* synthetic */ ASquareEnv access$1600(Location x0) {
            return x0.ASquareEnv.this;
        }
    }

    public class Direction {
        private final double EPSILON = 1.0E-10;
        private double _dx;
        private double _dy;

        public double getDeltaX() {
            return this._dx;
        }

        public double getDeltaY() {
            return this._dy;
        }

        public Direction duplicate() {
            return ASquareEnv.this.makeDirection(this._dx, this._dy);
        }

        public void reverseDirection() {
            this._dx = -this._dx;
            this._dy = -this._dy;
        }

        public boolean same(Direction other) {
            double diffx = this._dx - other.getDeltaX();
            double diffy = this._dy - other.getDeltaY();
            return Math.abs(diffx) < 1.0E-10 && Math.abs(diffy) < 1.0E-10;
        }

        public void turnLeft(double radians) {
            this.turnRight(-radians);
        }

        public void turnLeft() {
            this.turnLeft(1.5707963267948966);
        }

        public void turnRight(double radians) {
            double dx = this._dx * Math.cos(radians) - this._dy * Math.sin(radians);
            double dy = this._dx * Math.sin(radians) + this._dy * Math.cos(radians);
            this._dx = Math.abs(dx) < 1.0E-10 ? 0.0 : dx;
            this._dy = Math.abs(dy) < 1.0E-10 ? 0.0 : dy;
        }

        public void turnRight() {
            this.turnRight(1.5707963267948966);
        }

        public Direction(Direction other) {
            this._dx = other.getDeltaX();
            this._dy = other.getDeltaY();
        }

        public Direction(double dx, double dy) {
            this._dx = dx;
            this._dy = dy;
        }

        public Direction() {
            this._dx = 0.0;
            this._dy = -1.0;
        }

        public String toString() {
            return "(" + (int)(this.getAngle() / Math.PI * 180.0) + " deg)";
        }

        public Direction parse(Lexer l) {
            return (Direction)l.nextToken().execute(new DefaultTokenVisitor(this, l){
                private final /* synthetic */ Lexer val$l;
                private final /* synthetic */ Direction this$1;
                {
                    this.this$1 = this$1;
                    this.val$l = val$l;
                }

                public Object defaultCase() {
                    throw new ParserException("Invalid token");
                }

                public Object openCase() {
                    return this.val$l.nextToken().execute(new DefaultTokenVisitor(this){
                        private final /* synthetic */ 6 this$2;
                        {
                            this.this$2 = this$2;
                        }

                        public Object defaultCase() {
                            throw new ParserException("Invalid token");
                        }

                        public Object numCase(double x) {
                            return 6.access$1000(this.this$2).nextToken().execute(new DefaultTokenVisitor(this, x){
                                private final /* synthetic */ double val$x;
                                private final /* synthetic */ 7 this$3;
                                {
                                    this.this$3 = this$3;
                                    this.val$x = val$x;
                                }

                                public Object defaultCase() {
                                    throw new ParserException("Invalid token");
                                }

                                public Object commaCase() {
                                    return 6.access$1000(7.access$700(this.this$3)).nextToken().execute(new DefaultTokenVisitor(this){
                                        private final /* synthetic */ 8 this$4;
                                        {
                                            this.this$4 = this$4;
                                        }

                                        public Object defaultCase() {
                                            throw new ParserException("Invalid token");
                                        }

                                        public Object numCase(double y) {
                                            return 6.access$1000(7.access$700(8.access$600(this.this$4))).nextToken().execute(new DefaultTokenVisitor(this, y){
                                                private final /* synthetic */ double val$y;
                                                private final /* synthetic */ 9 this$5;
                                                {
                                                    this.this$5 = this$5;
                                                    this.val$y = val$y;
                                                }

                                                public Object defaultCase() {
                                                    throw new ParserException("Invalid token");
                                                }

                                                public Object closeCase() {
                                                    return Direction.access$900(6.access$800(7.access$700(8.access$600(9.access$400(this.this$5))))).makeDirection(8.access$500(9.access$400(this.this$5)), this.val$y);
                                                }
                                            });
                                        }

                                        static /* synthetic */ 8 access$400(9 x0) {
                                            return x0.this$4;
                                        }
                                    });
                                }

                                static /* synthetic */ double access$500(8 x0) {
                                    return x0.val$x;
                                }

                                static /* synthetic */ 7 access$600(8 x0) {
                                    return x0.this$3;
                                }
                            });
                        }

                        static /* synthetic */ 6 access$700(7 x0) {
                            return x0.this$2;
                        }
                    });
                }

                static /* synthetic */ Direction access$800(6 x0) {
                    return x0.this$1;
                }

                static /* synthetic */ Lexer access$1000(6 x0) {
                    return x0.val$l;
                }
            });
        }

        public void rotateGraphics(Graphics2D g) {
            double theta = this.getAngle();
            if (g != null) {
                g.rotate(theta);
            }
        }

        public double getAngle() {
            double theta = Math.acos(-this._dy);
            if (this._dx < 0.0) {
                theta = Math.PI * 2 - theta;
            }
            if (theta == Math.PI * 2) {
                return 0.0;
            }
            return theta;
        }

        static /* synthetic */ ASquareEnv access$900(Direction x0) {
            return x0.ASquareEnv.this;
        }
    }
}

