/*
 * Decompiled with CFR 0.152.
 */
package sysModel.env;

import controller.IScrollAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.env.AEnvFactory;
import sysModel.env.AGlobalEnv;
import sysModel.env.ASquareEnv;
import sysModel.env.DeactivatableLambda;
import sysModel.env.EmptyLocalEnvState;
import sysModel.env.ILocalEnv;
import sysModel.env.ILocalEnvState;
import sysModel.fish.AFish;
import sysModel.parser.DefaultTokenVisitor;
import sysModel.parser.Lexer;
import sysModel.parser.ParserException;

public class BoundedEnv
extends ASquareEnv {
    protected final int PAN_SIZE = 2000;
    protected final Point2D.Double PAN_CENTER = new Point2D.Double(1000.0, 1000.0);
    protected IField[][] _fieldMap;
    protected int _width;
    protected int _height;
    static /* synthetic */ Class class$sysModel$env$BoundedEnv;
    static /* synthetic */ Class class$sysModel$env$DeactivatableLambda;

    public BoundedEnv(ICmdFactory cmdFactory) {
        super(cmdFactory);
        this._fieldMap = new IField[0][0];
    }

    public BoundedEnv(ICmdFactory cmdFactory, int width, int height) {
        super(cmdFactory);
        this._width = width;
        this._height = height;
        this._fieldMap = new IField[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this._fieldMap[x][y] = EmptyField.Singleton;
            }
        }
    }

    protected void addFishToInternalData(ILocalEnv localEnv, AFish fish) {
        this._fieldMap[(int)((LocalEnvironment)localEnv).location().getX()][(int)((LocalEnvironment)localEnv).location().getY()] = new NonEmptyField((LocalEnvironment)localEnv);
    }

    protected void removeFishFromInternalData(ILocalEnv localEnv) {
        this._fieldMap[(int)((LocalEnvironment)localEnv).location().getX()][(int)((LocalEnvironment)localEnv).location().getY()] = EmptyField.Singleton;
    }

    protected ASquareEnv.ISquareLocalEnvironment makeLocalEnv(final ASquareEnv.Location loc, final ASquareEnv.Direction dir) {
        return (ASquareEnv.ISquareLocalEnvironment)this._fieldMap[(int)loc.getX()][(int)loc.getY()].execute(new IFieldVisitor(){

            public Object emptyCase(EmptyField host, Object inp) {
                return new LocalEnvironment(loc, dir);
            }

            public Object nonEmptyCase(NonEmptyField host, Object inp) {
                return host.getLocalEnv();
            }
        }, null);
    }

    protected ASquareEnv.ISquareLocalEnvironment createLocalEnvironment(ASquareEnv.Location loc, ASquareEnv.Direction dir) {
        return new LocalEnvironment(loc, dir);
    }

    protected AGlobalEnv parseEnvironment(final Lexer l) {
        return (AGlobalEnv)l.nextToken().execute(new DefaultTokenVisitor(){

            public Object defaultCase() {
                throw new ParserException("Invalid token");
            }

            public Object numCase(double width) {
                return (AGlobalEnv)l.nextToken().execute(new DefaultTokenVisitor(this, width){
                    private final /* synthetic */ double val$width;
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$width = val$width;
                    }

                    public Object defaultCase() {
                        throw new ParserException("Invalid token");
                    }

                    public Object numCase(double height) {
                        BoundedEnv env = new BoundedEnv(4.access$100(this.this$1)._cmdFactory, (int)this.val$width, (int)height);
                        env.parseFish(4.access$200(this.this$1));
                        return env;
                    }
                });
            }

            static /* synthetic */ BoundedEnv access$100(4 x0) {
                return x0.BoundedEnv.this;
            }

            static /* synthetic */ Lexer access$200(4 x0) {
                return x0.l;
            }
        });
    }

    public AEnvFactory makeEnvFactory() {
        return new AEnvFactory(){
            private JTextField _rowField;
            private JTextField _colField;
            {
                this.setLayout(new BoxLayout(this, 0));
                this.add(new JLabel("rows: "));
                this._rowField = new JTextField("10");
                this.add(this._rowField);
                this.add(new JLabel("  cols: "));
                this._colField = new JTextField("10");
                this.add(this._colField);
            }

            public AGlobalEnv create() {
                return new BoundedEnv(BoundedEnv.this._cmdFactory, Integer.parseInt(this._colField.getText()), Integer.parseInt(this._rowField.getText()));
            }

            public String toString() {
                return (class$sysModel$env$BoundedEnv == null ? (class$sysModel$env$BoundedEnv = BoundedEnv.class$("sysModel.env.BoundedEnv")) : class$sysModel$env$BoundedEnv).getName();
            }
        };
    }

    protected void printHeader(PrintWriter pw) {
        pw.println(this.getClass().getName());
    }

    public Dimension getDisplaySize() {
        return new Dimension(this._width, this._height);
    }

    public void returnHome(IScrollAdapter sa) {
        sa.setCorner(0, 0);
    }

    public Point2D.Double getViewPosition(Point2D.Double pos) {
        return pos;
    }

    public Point2D.Double getPanDelta(Point2D.Double delta) {
        return new Point2D.Double(0.0, 0.0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class LocalEnvironment
    implements ASquareEnv.ISquareLocalEnvironment {
        ASquareEnv.Location _loc;
        ASquareEnv.Direction _dir;
        ILocalEnvState _state = EmptyLocalEnvState.Singleton;

        public LocalEnvironment(ASquareEnv.Location loc, ASquareEnv.Direction dir) {
            this._loc = loc;
            this._dir = dir;
        }

        public ASquareEnv.Location location() {
            return this._loc;
        }

        public ASquareEnv.Direction direction() {
            return this._dir;
        }

        private ILocalEnv makeMoveFwdLocalEnv() {
            BoundedEnv.this._fieldMap[(int)this.location().getX()][(int)this.location().getY()] = EmptyField.Singleton;
            ASquareEnv.ISquareLocalEnvironment le = BoundedEnv.this.makeLocalEnv(this._loc.getNeighbor(this._dir), this._dir);
            BoundedEnv.this._fieldMap[(int)this.location().getX()][(int)this.location().getY()] = new NonEmptyField(this);
            return le;
        }

        public Object tryMoveFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            if (this.outOfRange(this._loc.getNeighbor(this._dir))) {
                return blockedCmd.apply(null);
            }
            LocalEnvironment newLocalEnv = (LocalEnvironment)this.makeMoveFwdLocalEnv();
            return newLocalEnv.execute(new AGlobalEnv.ILocalEnvVisitor(this, newLocalEnv, openCmd, blockedCmd){
                private final /* synthetic */ LocalEnvironment val$newLocalEnv;
                private final /* synthetic */ ILambda val$openCmd;
                private final /* synthetic */ ILambda val$blockedCmd;
                private final /* synthetic */ LocalEnvironment this$1;
                {
                    this.this$1 = this$1;
                    this.val$newLocalEnv = val$newLocalEnv;
                    this.val$openCmd = val$openCmd;
                    this.val$blockedCmd = val$blockedCmd;
                }

                public Object emptyCase(ILocalEnv host, Object param) {
                    DeactivatableLambda moveLambda = new DeactivatableLambda(this.this$1.new MoveLambda(this.val$newLocalEnv));
                    LocalEnvironment.access$000((LocalEnvironment)this.this$1)._moveLambdas.insertFront(moveLambda);
                    return this.val$openCmd.apply(moveLambda);
                }

                public Object nonEmptyCase(ILocalEnv host, Object param) {
                    return this.val$blockedCmd.apply(null);
                }
            }, null);
        }

        public Object tryBreedFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            ASquareEnv.Location newLoc = this._loc.getNeighbor(this._dir);
            if (this.outOfRange(newLoc)) {
                return blockedCmd.apply(null);
            }
            LocalEnvironment newLocalEnv = (LocalEnvironment)BoundedEnv.this.makeLocalEnv(newLoc, BoundedEnv.this.makeDirection());
            return newLocalEnv.execute(new AGlobalEnv.ILocalEnvVisitor(this, fish, newLocalEnv, openCmd, blockedCmd){
                private final /* synthetic */ AFish val$fish;
                private final /* synthetic */ LocalEnvironment val$newLocalEnv;
                private final /* synthetic */ ILambda val$openCmd;
                private final /* synthetic */ ILambda val$blockedCmd;
                private final /* synthetic */ LocalEnvironment this$1;
                {
                    this.this$1 = this$1;
                    this.val$fish = val$fish;
                    this.val$newLocalEnv = val$newLocalEnv;
                    this.val$openCmd = val$openCmd;
                    this.val$blockedCmd = val$blockedCmd;
                }

                public Object emptyCase(ILocalEnv host, Object param) {
                    DeactivatableLambda breedLambda = new DeactivatableLambda(LocalEnvironment.access$000(this.this$1).new AGlobalEnv.BreedLambda(this.val$fish, this.val$newLocalEnv));
                    LocalEnvironment.access$000((LocalEnvironment)this.this$1)._moveLambdas.insertFront(breedLambda);
                    return this.val$openCmd.apply(breedLambda);
                }

                public Object nonEmptyCase(ILocalEnv host, Object param) {
                    return this.val$blockedCmd.apply(null);
                }
            }, null);
        }

        public void drawFish(AFish fish, Graphics2D g, Component comp) {
            double centerX = Math.floor(this._loc.getX()) + 0.5;
            double centerY = Math.floor(this._loc.getY()) + 0.5;
            AffineTransform oldTransform = g.getTransform();
            g.translate(centerX, centerY);
            this._dir.rotateGraphics(g);
            fish.paint(g, comp);
            g.setTransform(oldTransform);
        }

        public void turnRight(AFish fish, double radians) {
            this._dir.turnRight(radians);
        }

        public void removeFish(AFish fish) {
            BoundedEnv.this.removeFish(this);
        }

        public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
            return this._state.execute(this, visitor, param);
        }

        public String toString() {
            return this._loc.toString() + " " + this._dir.toString();
        }

        public void setState(ILocalEnvState state) {
            this._state = state;
        }

        public boolean outOfRange(ASquareEnv.Location l) {
            long x = (int)Math.floor(l.getX());
            long y = (int)Math.floor(l.getY());
            return x < 0L || y < 0L || x >= (long)BoundedEnv.this._width || y >= (long)BoundedEnv.this._height;
        }

        private class MoveLambda
        implements ILambda {
            private ASquareEnv.Direction _newDir;
            private ASquareEnv.Location _newLoc;

            public MoveLambda(LocalEnvironment le) {
                this._newLoc = BoundedEnv.this.makeLocation(le._loc.getX(), le._loc.getY());
                this._newDir = BoundedEnv.this.makeDirection(le._dir);
            }

            public Object apply(Object param) {
                ((LocalEnvironment)LocalEnvironment.this).BoundedEnv.this._fieldMap[(int)LocalEnvironment.this._loc.getX()][(int)LocalEnvironment.this._loc.getY()] = EmptyField.Singleton;
                LocalEnvironment.this._loc = this._newLoc;
                LocalEnvironment.this._dir = this._newDir;
                ((LocalEnvironment)LocalEnvironment.this).BoundedEnv.this._fieldMap[(int)LocalEnvironment.this._loc.getX()][(int)LocalEnvironment.this._loc.getY()] = new NonEmptyField(LocalEnvironment.this);
                BoundedEnv.this.deactivateMoveLambdas();
                return null;
            }
        }
    }

    public static interface IFieldVisitor {
        public Object emptyCase(EmptyField var1, Object var2);

        public Object nonEmptyCase(NonEmptyField var1, Object var2);
    }

    public static class NonEmptyField
    implements IField {
        private LocalEnvironment _localEnv;

        public NonEmptyField(LocalEnvironment localEnv) {
            this._localEnv = localEnv;
        }

        public LocalEnvironment getLocalEnv() {
            return this._localEnv;
        }

        public void setLocalEnv(LocalEnvironment localEnv) {
            this._localEnv = localEnv;
        }

        public Object execute(IFieldVisitor vis, Object param) {
            return vis.nonEmptyCase(this, param);
        }
    }

    public static class EmptyField
    implements IField {
        public static final EmptyField Singleton = new EmptyField();

        private EmptyField() {
        }

        public Object execute(IFieldVisitor vis, Object param) {
            return vis.emptyCase(this, param);
        }
    }

    public static interface IField {
        public Object execute(IFieldVisitor var1, Object var2);
    }
}

