/*
 * Decompiled with CFR 0.152.
 */
package sysModel.env;

import controller.IScrollAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import lrs.IAlgo;
import lrs.LRStruct;
import lrs.visitor.Remove;
import model.ILambda;
import model.RandNumGenerator;
import sysModel.ICmdFactory;
import sysModel.NoOpLambda;
import sysModel.env.AEnvFactory;
import sysModel.env.AGlobalEnv;
import sysModel.env.DeactivatableLambda;
import sysModel.env.EmptyLocalEnvState;
import sysModel.env.FishApplyParams;
import sysModel.env.ILocalEnv;
import sysModel.env.ILocalEnvState;
import sysModel.env.NoGridEnv;
import sysModel.env.UnboundedEnv;
import sysModel.fish.AFish;
import sysModel.fish.IFishFactory;
import sysModel.parser.DefaultTokenVisitor;
import sysModel.parser.Lexer;
import sysModel.parser.ParserException;

public class NoGridEnv
extends AGlobalEnv {
    private static int PAN_SIZE = 2000;
    private static Point2D.Double PAN_CENTER = new Point2D.Double(PAN_SIZE / 2, PAN_SIZE / 2);
    private LRStruct _localEnvList = new LRStruct();
    private int _rotSteps;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$sysModel$env$NoGridEnv;
    static /* synthetic */ Class class$sysModel$env$DeactivatableLambda;

    public NoGridEnv(ICmdFactory cmdFactory) {
        super(cmdFactory);
    }

    public NoGridEnv(ICmdFactory cmdFactory, int rotSteps, Color waterColor) {
        super(cmdFactory);
        this._rotSteps = rotSteps;
        this._waterColor = waterColor;
    }

    protected void addFishToInternalData(ILocalEnv localEnv, AFish fish) {
        this._localEnvList.insertFront(localEnv);
    }

    protected void removeFishFromInternalData(ILocalEnv localEnv) {
        this._localEnvList.execute(Remove.Singleton, localEnv);
    }

    public ILocalEnv makeLocalEnv(Point2D.Double p) {
        return this.makeLocalEnv(new Location(p.getX(), p.getY()), new Direction());
    }

    private ILocalEnv makeLocalEnv(final Location loc, final Direction dir) {
        return (ILocalEnv)this._localEnvList.execute(new IAlgo(){

            public Object nonEmptyCase(LRStruct host, Object inp) {
                LocalEnvironment localEnv = (LocalEnvironment)host.getFirst();
                if (localEnv.location().inSquare(loc, localEnv.direction(), 1.0)) {
                    return localEnv;
                }
                return host.getRest().execute(this, inp);
            }

            public Object emptyCase(LRStruct host, Object inp) {
                return new LocalEnvironment(loc, dir);
            }
        }, null);
    }

    protected LocalEnvironment createLocalEnvironment(Location loc, Direction dir) {
        return new LocalEnvironment(loc, dir);
    }

    public ILambda editFish(ILocalEnv le, IFishFactory fishFactory, int button) {
        ILambda lambdaForControl = NoOpLambda.instance();
        LocalEnvironment localEnv = (LocalEnvironment)le;
        if (button == 1) {
            double initialAngle = localEnv.direction().getAngle();
            localEnv.direction().turnRight(Math.PI * 2 / (double)this._rotSteps);
            if (initialAngle > localEnv.direction().getAngle()) {
                lambdaForControl = this._cmdFactory.makeDeleteCmd(localEnv);
                this.removeFish(le);
            }
        }
        return lambdaForControl;
    }

    protected AGlobalEnv parseEnvironment(Lexer l) {
        UnboundedEnv env = new UnboundedEnv(this._cmdFactory);
        env.parseFish(l);
        return env;
    }

    protected void parseFish(final Lexer l) {
        while (l.nextToken().execute(new DefaultTokenVisitor(){

            public Object defaultCase() {
                throw new ParserException("Invalid token");
            }

            public Object endCase() {
                return Boolean.FALSE;
            }

            public Object wordCase(String className) {
                try {
                    Class<?> fishClass = Class.forName(className);
                    Constructor<?> fishCtor = fishClass.getConstructor(class$java$awt$Color == null ? (class$java$awt$Color = NoGridEnv.class$("java.awt.Color")) : class$java$awt$Color);
                    RandNumGenerator rng = RandNumGenerator.instance();
                    AFish fish = (AFish)fishCtor.newInstance(new Color(rng.nextInt(256), rng.nextInt(256), rng.nextInt(256)));
                    Location loc = Location.parse(l);
                    Direction dir = Direction.parse(l);
                    LocalEnvironment localEnv = NoGridEnv.this.createLocalEnvironment(loc, dir);
                    ILambda addLambda = NoGridEnv.this.addFish(localEnv, fish);
                    addLambda.apply(null);
                    return Boolean.TRUE;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ParserException(e.toString());
                }
            }
        }) == Boolean.TRUE) {
        }
    }

    public AEnvFactory makeEnvFactory() {
        return new AEnvFactory(){
            private JTextField _rotStepsField;
            private JColorChooser _colorChooser;
            {
                this.setLayout(new BoxLayout(this, 1));
                this.add(new JLabel("rotation steps: "));
                this._rotStepsField = new JTextField("24");
                this.add(this._rotStepsField);
                this.add(new JLabel("water color: "));
                this._colorChooser = new JColorChooser(AGlobalEnv.OCEAN_BLUE);
                this.add(this._colorChooser);
            }

            public AGlobalEnv create() {
                return new NoGridEnv(NoGridEnv.this._cmdFactory, Integer.parseInt(this._rotStepsField.getText()), this._colorChooser.getColor());
            }

            public String toString() {
                return (class$sysModel$env$NoGridEnv == null ? (class$sysModel$env$NoGridEnv = NoGridEnv.class$("sysModel.env.NoGridEnv")) : class$sysModel$env$NoGridEnv).getName();
            }
        };
    }

    protected void printHeader(PrintWriter pw) {
        pw.println(this.getClass().getName());
    }

    public Dimension getDisplaySize() {
        return new Dimension(PAN_SIZE, PAN_SIZE);
    }

    public void returnHome(IScrollAdapter sa) {
        sa.setCorner((int)NoGridEnv.PAN_CENTER.x, (int)NoGridEnv.PAN_CENTER.y);
        sa.resetScrolling();
    }

    public Point2D.Double getViewPosition(Point2D.Double pos) {
        return PAN_CENTER;
    }

    public Point2D.Double getPanDelta(Point2D.Double delta) {
        return delta;
    }

    public ILambda getToolTipText(final Point2D.Double p) {
        final LocalEnvironment l = this.createLocalEnvironment(new Location(p.x, p.y), new Direction());
        return (ILambda)l.execute(new AGlobalEnv.ILocalEnvVisitor(){

            public Object emptyCase(ILocalEnv host, Object param) {
                return new ILambda(this){
                    private final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object apply(Object param) {
                        return "(" + 16.access$1300(this.this$1).x + "," + 16.access$1300(this.this$1).y + ") is empty";
                    }
                };
            }

            public Object nonEmptyCase(ILocalEnv host, Object param) {
                return new ILambda(this){
                    String _fishName;
                    ILocalEnv _localEnv;
                    private final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object apply(Object param) {
                        this._fishName = "";
                        16.access$1600(this.this$1)._cmdFactory.makeNotifyCmd(new ILambda(this){
                            private final /* synthetic */ 18 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public Object apply(Object param) {
                                FishApplyParams fap = (FishApplyParams)param;
                                LocalEnvironment lenv = (LocalEnvironment)fap.localEnv();
                                if (lenv.location().inSquare(16.access$1500(18.access$1400(this.this$2)).location(), lenv.direction(), 1.0)) {
                                    this.this$2._fishName = fap.fish().toString();
                                    this.this$2._localEnv = fap.localEnv();
                                }
                                return null;
                            }
                        }).apply(null);
                        return this._fishName + " at " + this._localEnv;
                    }

                    static /* synthetic */ 16 access$1400(18 x0) {
                        return x0.this$1;
                    }
                };
            }

            static /* synthetic */ Point2D.Double access$1300(16 x0) {
                return x0.p;
            }

            static /* synthetic */ LocalEnvironment access$1500(16 x0) {
                return x0.l;
            }

            static /* synthetic */ NoGridEnv access$1600(16 x0) {
                return x0.NoGridEnv.this;
            }
        }, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Point2D.Double access$2000() {
        return PAN_CENTER;
    }

    protected class LocalEnvironment
    implements ILocalEnv {
        Location _loc;
        Direction _dir;
        ILocalEnvState _state = EmptyLocalEnvState.Singleton;

        public LocalEnvironment(Location loc, Direction dir) {
            this._loc = loc;
            this._dir = dir;
        }

        public Location location() {
            return this._loc;
        }

        public Direction direction() {
            return this._dir;
        }

        private ILocalEnv makeMoveFwdLocalEnv() {
            NoGridEnv.this._localEnvList.execute(Remove.Singleton, this);
            ILocalEnv le = NoGridEnv.this.makeLocalEnv(this._loc.getNeighbor(this._dir), this._dir);
            NoGridEnv.this._localEnvList.insertFront(this);
            return le;
        }

        public Object tryMoveFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            LocalEnvironment newLocalEnv = (LocalEnvironment)this.makeMoveFwdLocalEnv();
            return newLocalEnv.execute(new AGlobalEnv.ILocalEnvVisitor(this, newLocalEnv, openCmd, blockedCmd){
                private final /* synthetic */ LocalEnvironment val$newLocalEnv;
                private final /* synthetic */ ILambda val$openCmd;
                private final /* synthetic */ ILambda val$blockedCmd;
                private final /* synthetic */ LocalEnvironment this$1;
                {
                    this.this$1 = this$1;
                    this.val$newLocalEnv = val$newLocalEnv;
                    this.val$openCmd = val$openCmd;
                    this.val$blockedCmd = val$blockedCmd;
                }

                public Object emptyCase(ILocalEnv host, Object param) {
                    DeactivatableLambda moveLambda = new DeactivatableLambda(this.this$1.new MoveLambda(this.val$newLocalEnv));
                    LocalEnvironment.access$1000((LocalEnvironment)this.this$1)._moveLambdas.insertFront(moveLambda);
                    return this.val$openCmd.apply(moveLambda);
                }

                public Object nonEmptyCase(ILocalEnv host, Object param) {
                    return this.val$blockedCmd.apply(null);
                }
            }, null);
        }

        public Object tryBreedFwd(AFish fish, ILambda blockedCmd, ILambda openCmd) {
            LocalEnvironment newLocalEnv = (LocalEnvironment)NoGridEnv.this.makeLocalEnv(this._loc.getNeighbor(this._dir), new Direction());
            return newLocalEnv.execute(new AGlobalEnv.ILocalEnvVisitor(this, fish, newLocalEnv, openCmd, blockedCmd){
                private final /* synthetic */ AFish val$fish;
                private final /* synthetic */ LocalEnvironment val$newLocalEnv;
                private final /* synthetic */ ILambda val$openCmd;
                private final /* synthetic */ ILambda val$blockedCmd;
                private final /* synthetic */ LocalEnvironment this$1;
                {
                    this.this$1 = this$1;
                    this.val$fish = val$fish;
                    this.val$newLocalEnv = val$newLocalEnv;
                    this.val$openCmd = val$openCmd;
                    this.val$blockedCmd = val$blockedCmd;
                }

                public Object emptyCase(ILocalEnv host, Object param) {
                    DeactivatableLambda breedLambda = new DeactivatableLambda(LocalEnvironment.access$1000(this.this$1).new AGlobalEnv.BreedLambda(this.val$fish, this.val$newLocalEnv));
                    LocalEnvironment.access$1000((LocalEnvironment)this.this$1)._moveLambdas.insertFront(breedLambda);
                    return this.val$openCmd.apply(breedLambda);
                }

                public Object nonEmptyCase(ILocalEnv host, Object param) {
                    return this.val$blockedCmd.apply(null);
                }
            }, null);
        }

        public void drawFish(AFish fish, Graphics2D g, Component comp) {
            double centerX = this._loc.getX();
            double centerY = this._loc.getY();
            AffineTransform oldTransform = g.getTransform();
            g.translate(centerX, centerY);
            this._dir.rotateGraphics(g);
            fish.paint(g, comp);
            g.setTransform(oldTransform);
        }

        public void turnRight(AFish fish, double radians) {
            this._dir.turnRight(radians);
        }

        public void removeFish(AFish fish) {
            NoGridEnv.this.removeFish(this);
        }

        public Object execute(AGlobalEnv.ILocalEnvVisitor visitor, Object param) {
            return this._state.execute(this, visitor, param);
        }

        public String toString() {
            return this._loc.toString() + " " + this._dir.toString();
        }

        public void setState(ILocalEnvState state) {
            this._state = state;
        }

        private class MoveLambda
        implements ILambda {
            private Direction _newDir;
            private Location _newLoc;

            public MoveLambda(LocalEnvironment le) {
                this._newLoc = new Location(le._loc.getX(), le._loc.getY());
                this._newDir = new Direction(le._dir);
            }

            public Object apply(Object param) {
                LocalEnvironment.this._loc = this._newLoc;
                LocalEnvironment.this._dir = this._newDir;
                NoGridEnv.this.deactivateMoveLambdas();
                return null;
            }
        }
    }

    public static class Location {
        private double _x;
        private double _y;

        public double getX() {
            return this._x;
        }

        public double getY() {
            return this._y;
        }

        public void setX(double _x) {
            this._x = _x;
        }

        public void setY(double _y) {
            this._y = _y;
        }

        public Location(double x, double y) {
            this._x = x;
            this._y = y;
        }

        public boolean same(Location other) {
            return this._x == other.getX() && this._y == other.getY();
        }

        public boolean inSquare(Location other, Direction forward, double side) {
            double rightY;
            double frontY;
            double deltaX = other.getX() - this._x;
            double deltaY = other.getY() - this._y;
            double frontX = forward.getDeltaX();
            double toFront = deltaX * frontX + deltaY * (frontY = forward.getDeltaY());
            if (Math.abs(toFront) > side / 2.0) {
                return false;
            }
            double rightX = -forward.getDeltaY();
            double toRight = deltaX * rightX + deltaY * (rightY = forward.getDeltaX());
            return !(Math.abs(toRight) > side / 2.0);
        }

        public Location getNeighbor(Direction dir) {
            return new Location(this._x + dir.getDeltaX(), this._y + dir.getDeltaY());
        }

        public String toString() {
            return "(" + this._x + ", " + this._y + ")";
        }

        public static Location parse(Lexer l) {
            return (Location)l.nextToken().execute(new DefaultTokenVisitor(l){
                private final /* synthetic */ Lexer val$l;
                {
                    this.val$l = val$l;
                }

                public Object defaultCase() {
                    throw new ParserException("Invalid token");
                }

                public Object openCase() {
                    return this.val$l.nextToken().execute(new DefaultTokenVisitor(this){
                        private final /* synthetic */ 6 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public Object defaultCase() {
                            throw new ParserException("Invalid token");
                        }

                        public Object numCase(double x) {
                            return 6.access$900(this.this$0).nextToken().execute(new DefaultTokenVisitor(this, x){
                                private final /* synthetic */ double val$x;
                                private final /* synthetic */ 7 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$x = val$x;
                                }

                                public Object defaultCase() {
                                    throw new ParserException("Invalid token");
                                }

                                public Object commaCase() {
                                    return 6.access$900(7.access$800(this.this$1)).nextToken().execute(new DefaultTokenVisitor(this){
                                        private final /* synthetic */ 8 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        public Object defaultCase() {
                                            throw new ParserException("Invalid token");
                                        }

                                        public Object numCase(double y) {
                                            return 6.access$900(7.access$800(8.access$700(this.this$2))).nextToken().execute(new DefaultTokenVisitor(this, y){
                                                private final /* synthetic */ double val$y;
                                                private final /* synthetic */ 9 this$3;
                                                {
                                                    this.this$3 = this$3;
                                                    this.val$y = val$y;
                                                }

                                                public Object defaultCase() {
                                                    throw new ParserException("Invalid token");
                                                }

                                                public Object closeCase() {
                                                    return new Location(8.access$600(9.access$500(this.this$3)), this.val$y);
                                                }
                                            });
                                        }

                                        static /* synthetic */ 8 access$500(9 x0) {
                                            return x0.this$2;
                                        }
                                    });
                                }

                                static /* synthetic */ double access$600(8 x0) {
                                    return x0.val$x;
                                }

                                static /* synthetic */ 7 access$700(8 x0) {
                                    return x0.this$1;
                                }
                            });
                        }

                        static /* synthetic */ 6 access$800(7 x0) {
                            return x0.this$0;
                        }
                    });
                }

                static /* synthetic */ Lexer access$900(6 x0) {
                    return x0.val$l;
                }
            });
        }
    }

    public static class Direction {
        private static double EPSILON = 1.0E-10;
        private double _dx;
        private double _dy;

        public double getDeltaX() {
            return this._dx;
        }

        public double getDeltaY() {
            return this._dy;
        }

        public Direction duplicate() {
            return new Direction(this._dx, this._dy);
        }

        public void reverseDirection() {
            this._dx = -this._dx;
            this._dy = -this._dy;
        }

        public boolean same(Direction other) {
            double diffx = this._dx - other.getDeltaX();
            double diffy = this._dy - other.getDeltaY();
            return Math.abs(diffx) < EPSILON && Math.abs(diffy) < EPSILON;
        }

        public void turnLeft(double radians) {
            this.turnRight(-radians);
        }

        public void turnLeft() {
            this.turnLeft(1.5707963267948966);
        }

        public void turnRight(double radians) {
            double dx = this._dx * Math.cos(radians) - this._dy * Math.sin(radians);
            double dy = this._dx * Math.sin(radians) + this._dy * Math.cos(radians);
            this._dx = dx;
            this._dy = dy;
        }

        public void turnRight() {
            this.turnRight(1.5707963267948966);
        }

        public Direction(double dx, double dy) {
            this._dx = dx;
            this._dy = dy;
        }

        public Direction(Direction other) {
            this._dx = other.getDeltaX();
            this._dy = other.getDeltaY();
        }

        public Direction() {
            this._dx = 0.0;
            this._dy = -1.0;
        }

        public String toString() {
            return "(" + this._dx + ", " + this._dy + ")";
        }

        public static Direction parse(Lexer l) {
            return (Direction)l.nextToken().execute(new DefaultTokenVisitor(l){
                private final /* synthetic */ Lexer val$l;
                {
                    this.val$l = val$l;
                }

                public Object defaultCase() {
                    throw new ParserException("Invalid token");
                }

                public Object openCase() {
                    return this.val$l.nextToken().execute(new DefaultTokenVisitor(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public Object defaultCase() {
                            throw new ParserException("Invalid token");
                        }

                        public Object numCase(double x) {
                            return 1.access$400(this.this$0).nextToken().execute(new DefaultTokenVisitor(this, x){
                                private final /* synthetic */ double val$x;
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$x = val$x;
                                }

                                public Object defaultCase() {
                                    throw new ParserException("Invalid token");
                                }

                                public Object commaCase() {
                                    return 1.access$400(2.access$300(this.this$1)).nextToken().execute(new DefaultTokenVisitor(this){
                                        private final /* synthetic */ 3 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        public Object defaultCase() {
                                            throw new ParserException("Invalid token");
                                        }

                                        public Object numCase(double y) {
                                            return 1.access$400(2.access$300(3.access$200(this.this$2))).nextToken().execute(new DefaultTokenVisitor(this, y){
                                                private final /* synthetic */ double val$y;
                                                private final /* synthetic */ 4 this$3;
                                                {
                                                    this.this$3 = this$3;
                                                    this.val$y = val$y;
                                                }

                                                public Object defaultCase() {
                                                    throw new ParserException("Invalid token");
                                                }

                                                public Object closeCase() {
                                                    return new Direction(3.access$100(4.access$000(this.this$3)), this.val$y);
                                                }
                                            });
                                        }

                                        static /* synthetic */ 3 access$000(4 x0) {
                                            return x0.this$2;
                                        }
                                    });
                                }

                                static /* synthetic */ double access$100(3 x0) {
                                    return x0.val$x;
                                }

                                static /* synthetic */ 2 access$200(3 x0) {
                                    return x0.this$1;
                                }
                            });
                        }

                        static /* synthetic */ 1 access$300(2 x0) {
                            return x0.this$0;
                        }
                    });
                }

                static /* synthetic */ Lexer access$400(1 x0) {
                    return x0.val$l;
                }
            });
        }

        public void rotateGraphics(Graphics2D g) {
            double theta = this.getAngle();
            if (g != null) {
                g.rotate(theta);
            }
        }

        public double getAngle() {
            double theta = Math.acos(-this._dy);
            if (this._dx < 0.0) {
                theta = Math.PI * 2 - theta;
            }
            return theta;
        }
    }
}

