/*
 * Decompiled with CFR 0.152.
 */
package sysModel.fish;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.Observable;
import java.util.Observer;
import model.ILambda;
import model.RandNumGenerator;
import sysModel.env.FishApplyParams;
import sysModel.env.ILocalEnv;
import sysModel.fish.IFishDisplay;

public abstract class AFish
implements Cloneable,
Observer {
    private ILocalEnv _localEnv;
    protected double _probOfBreeding = 0.0;
    protected double _probOfDying = 0.0;
    protected Color _fishColor;
    protected IFishDisplay _fishDisplay;

    public AFish(Color fishColor, IFishDisplay fishDisplay) {
        this._fishColor = fishColor;
        this._fishDisplay = fishDisplay;
    }

    public final void setLocalEnvironment(ILocalEnv localEnv) {
        this._localEnv = localEnv;
    }

    public final Object tryMoveFwd(ILambda blockedCmd, ILambda openCmd) {
        return this._localEnv.tryMoveFwd(this, blockedCmd, openCmd);
    }

    public final Object tryBreedFwd(ILambda blockedCmd, ILambda openCmd) {
        return this._localEnv.tryBreedFwd(this, blockedCmd, openCmd);
    }

    public final void draw(Graphics2D g, Component comp) {
        this._localEnv.drawFish(this, g, comp);
    }

    public final void turnRight(double radians) {
        this._localEnv.turnRight(this, radians);
    }

    public final void turnLeft(double radians) {
        this._localEnv.turnRight(this, -radians);
    }

    public void turnRight() {
        this.turnRight(1.5707963267948966);
    }

    public void turnLeft() {
        this.turnLeft(1.5707963267948966);
    }

    public final void act() {
        this.breed();
        this.move();
        this.die();
    }

    protected void breed() {
        if (RandNumGenerator.instance().nextDouble() < this._probOfBreeding) {
            final ILambda blocked1 = new ILambda(){

                public Object apply(Object param) {
                    AFish.this.turnRight();
                    return null;
                }
            };
            final ILambda blocked2 = new ILambda(){

                public Object apply(Object param) {
                    AFish.this.turnRight();
                    return AFish.this.tryBreedFwd(blocked1, new ILambda(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object apply(Object param) {
                            ((ILambda)param).apply(null);
                            return 2.access$000(this.this$1).apply(null);
                        }
                    });
                }

                static /* synthetic */ ILambda access$000(2 x0) {
                    return x0.blocked1;
                }
            };
            final ILambda blocked3 = new ILambda(){

                public Object apply(Object param) {
                    AFish.this.turnRight();
                    return AFish.this.tryBreedFwd(blocked2, new ILambda(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object apply(Object param) {
                            ((ILambda)param).apply(null);
                            return 4.access$100(this.this$1).apply(null);
                        }
                    });
                }

                static /* synthetic */ ILambda access$100(4 x0) {
                    return x0.blocked2;
                }
            };
            final ILambda blocked4 = new ILambda(){

                public Object apply(Object param) {
                    AFish.this.turnRight();
                    return AFish.this.tryBreedFwd(blocked3, new ILambda(this){
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object apply(Object param) {
                            ((ILambda)param).apply(null);
                            return 6.access$200(this.this$1).apply(null);
                        }
                    });
                }

                static /* synthetic */ ILambda access$200(6 x0) {
                    return x0.blocked3;
                }
            };
            this.tryBreedFwd(blocked4, new ILambda(){

                public Object apply(Object param) {
                    ((ILambda)param).apply(null);
                    return blocked4.apply(null);
                }
            });
        }
    }

    protected void die() {
        if (RandNumGenerator.instance().nextDouble() < this._probOfDying) {
            this._localEnv.removeFish(this);
        }
    }

    public Object clone() {
        Object clone;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("AFish.clone failed");
        }
        return clone;
    }

    public String toString() {
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    protected abstract void move();

    public void paint(Graphics2D g, Component comp) {
        this._fishDisplay.draw(g, comp, this.getColor());
    }

    public Color getColor() {
        return this._fishColor;
    }

    public final void update(Observable o, Object arg) {
        ((ILambda)arg).apply(new FishApplyParams(this, this._localEnv));
    }

    public void setProbOfDying(double p) {
        this._probOfDying = p;
    }

    public void setProbOfBreeding(double p) {
        this._probOfBreeding = p;
    }
}

