/*
 * Decompiled with CFR 0.152.
 */
package sysModel.parser;

import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import sysModel.parser.CloseToken;
import sysModel.parser.CommaToken;
import sysModel.parser.EndOfStreamToken;
import sysModel.parser.IToken;
import sysModel.parser.NumberToken;
import sysModel.parser.OpenToken;
import sysModel.parser.ParserException;
import sysModel.parser.WordToken;

public class Lexer {
    final StreamTokenizer _tok;

    public Lexer(String filename) throws IOException {
        this._tok = new StreamTokenizer(new FileReader(filename));
        this._tok.wordChars(0, 255);
        this._tok.ordinaryChars(0, 32);
        this._tok.whitespaceChars(0, 32);
        this._tok.ordinaryChar(40);
        this._tok.ordinaryChar(41);
        this._tok.parseNumbers();
        this._tok.wordChars(46, 46);
        this._tok.ordinaryChar(44);
        this._tok.eolIsSignificant(false);
    }

    public IToken nextToken() {
        try {
            switch (this._tok.nextToken()) {
                case -3: {
                    return new WordToken(this._tok.sval);
                }
                case -2: {
                    return new NumberToken(this._tok.nval);
                }
                case 40: {
                    return OpenToken.instance();
                }
                case 41: {
                    return CloseToken.instance();
                }
                case 44: {
                    return CommaToken.instance();
                }
                case -1: {
                    return EndOfStreamToken.instance();
                }
            }
            throw new ParserException("Invalid token");
        }
        catch (IOException e) {
            throw new ParserException(e.toString());
        }
    }
}

