/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.IEnvAdapter;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import sysModel.env.AEnvFactory;
import sysModel.env.AGlobalEnv;
import view.InputStringDialog;

public class CreateEnvDialog {
    private AEnvFactory _envFactory;
    private JComboBox _envChooser;
    private JDialog _dialog;
    private JButton[] _optButtons;
    private JPanel _optionsPanel;
    private IEnvAdapter _envAdapter;
    static /* synthetic */ Class class$sysModel$ICmdFactory;

    public CreateEnvDialog(JFrame parent, IEnvAdapter ea) {
        this._envAdapter = ea;
        this._dialog = new JDialog(parent, "Create new environment", true);
        this._dialog.setContentPane(this.makeOptionsPanel());
        this._dialog.pack();
        this._dialog.setResizable(false);
    }

    public AEnvFactory showDialog() {
        this._envChooser.setSelectedIndex(0);
        this.envChosen();
        Container parent = this._dialog.getParent();
        this._dialog.setLocation(parent.getX() + parent.getWidth() / 2 - this._dialog.getSize().width / 2, parent.getY() + parent.getHeight() / 2 - this._dialog.getSize().height / 2);
        this._dialog.show();
        return this._envFactory;
    }

    private void removeEnvSettings() {
        if (this._envFactory != null) {
            this._optionsPanel.remove(this._envFactory);
            this._envFactory = null;
        }
    }

    private void addEnvSettings(AEnvFactory factory) {
        this._envFactory = factory;
        this._optionsPanel.add(this._envFactory);
    }

    private void envChosen() {
        IEnvChoice envChoice = (IEnvChoice)this._envChooser.getSelectedItem();
        envChoice.select();
        this._dialog.pack();
        this._dialog.getContentPane().validate();
    }

    private void cancelClicked() {
        this._dialog.setVisible(false);
        this.removeEnvSettings();
    }

    private void okClicked() {
        this._dialog.setVisible(false);
    }

    private JOptionPane makeOptionsPanel() {
        JPanel myControls = new JPanel();
        myControls.setLayout(new BoxLayout(myControls, 1));
        JLabel lab = new JLabel("Choose environment type: ");
        myControls.add(lab);
        lab.setAlignmentX(0.5f);
        this._envChooser = new JComboBox();
        String[] envClassNames = this._envAdapter.getEnvironmentClassNames();
        for (int i = 0; i < envClassNames.length; ++i) {
            try {
                Class<?> envClass = Class.forName(envClassNames[i]);
                Constructor<?> envCtor = envClass.getConstructor(class$sysModel$ICmdFactory == null ? CreateEnvDialog.class$("sysModel.ICmdFactory") : class$sysModel$ICmdFactory);
                AGlobalEnv env = (AGlobalEnv)envCtor.newInstance(this._envAdapter.getCmdFactory());
                AEnvFactory factory = env.makeEnvFactory();
                ConcreteEnvChoice choice = new ConcreteEnvChoice(this, factory);
                this._envChooser.addItem(choice);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._envChooser.addItem(new AddEnvChoice(this));
        this._envChooser.setBorder(BorderFactory.createEmptyBorder(5, 0, 10, 0));
        this._envChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateEnvDialog.this.envChosen();
            }
        });
        myControls.add(this._envChooser);
        this._optionsPanel = new JPanel();
        myControls.add(this._optionsPanel);
        JOptionPane optPane = new JOptionPane(myControls, 3);
        this._optButtons = new JButton[]{new JButton("Create"), new JButton("Cancel")};
        optPane.setOptions(this._optButtons);
        optPane.setInitialValue(this._optButtons[0]);
        this._optButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateEnvDialog.this.cancelClicked();
            }
        });
        this._optButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateEnvDialog.this.okClicked();
            }
        });
        return optPane;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AddEnvChoice
    implements IEnvChoice {
        private CreateEnvDialog _envDialog;

        public AddEnvChoice(CreateEnvDialog envDialog) {
            this._envDialog = envDialog;
        }

        public void select() {
            this._envDialog._optButtons[0].setEnabled(false);
            this._envDialog.removeEnvSettings();
            String className = new InputStringDialog(this._envDialog._dialog, "Add environment class").showDialog();
            try {
                Class<?> envClass = Class.forName(className);
                Constructor<?> envCtor = envClass.getConstructor(class$sysModel$ICmdFactory == null ? (class$sysModel$ICmdFactory = CreateEnvDialog.class$("sysModel.ICmdFactory")) : class$sysModel$ICmdFactory);
                AGlobalEnv env = (AGlobalEnv)envCtor.newInstance(CreateEnvDialog.this._envAdapter.getCmdFactory());
                AEnvFactory envFactory = env.makeEnvFactory();
                ConcreteEnvChoice choice = new ConcreteEnvChoice(this._envDialog, envFactory);
                this._envDialog._envChooser.insertItemAt(choice, this._envDialog._envChooser.getItemCount() - 1);
                this._envDialog._envChooser.setSelectedItem(choice);
                choice.select();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "Add ...";
        }
    }

    private static class ConcreteEnvChoice
    implements IEnvChoice {
        private CreateEnvDialog _envDialog;
        private AEnvFactory _envFactory;

        public ConcreteEnvChoice(CreateEnvDialog envDialog, AEnvFactory factory) {
            this._envDialog = envDialog;
            this._envFactory = factory;
        }

        public void select() {
            this._envDialog._optButtons[0].setEnabled(true);
            this._envDialog.removeEnvSettings();
            this._envDialog.addEnvSettings(this._envFactory);
        }

        public String toString() {
            return this._envFactory.toString();
        }
    }

    private static interface IEnvChoice {
        public void select();
    }
}

