/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.IDisplayAdapter;
import controller.IEnvAdapter;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import view.DisplayViewport;

public class DisplayPanel
extends JPanel
implements Scrollable,
DisplayViewport.Pannable {
    private static final int MIN_CELL_SIZE = 8;
    private static final int DEFAULT_CELL_SIZE = 32;
    IDisplayAdapter _displayAdapter;
    int _cellSize = 32;
    double _originX;
    double _originY;
    MouseAdapter _mouseAdapter;
    private boolean _toolTipsEnabled;
    IEnvAdapter _envAdapter;

    public DisplayPanel(IDisplayAdapter da, final IEnvAdapter ea) {
        this._displayAdapter = da;
        this._envAdapter = ea;
        this._mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                double x = (double)evt.getPoint().x / (double)DisplayPanel.this._cellSize + DisplayPanel.this._originX;
                double y = (double)evt.getPoint().y / (double)DisplayPanel.this._cellSize + DisplayPanel.this._originY;
                ea.edit(new Point2D.Double(x, y), evt.getButton());
                DisplayPanel.this.revalidate();
            }
        };
        this.setToolTipsEnabled(true);
        this.revalidate();
    }

    public void enableMouseAdapter(boolean enable) {
        if (enable) {
            this.addMouseListener(this._mouseAdapter);
        } else {
            this.removeMouseListener(this._mouseAdapter);
        }
    }

    public void setToolTipsEnabled(boolean flag) {
        if (flag) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
        this._toolTipsEnabled = flag;
    }

    public String getToolTipText(MouseEvent evt) {
        double x = (double)evt.getPoint().x / (double)this._cellSize + this._originX;
        double y = (double)evt.getPoint().y / (double)this._cellSize + this._originY;
        return this._envAdapter.getToolTipText(new Point2D.Double(x, y));
    }

    public void zoomIn() {
        double oldOriginX = this._originX;
        double oldOriginY = this._originY;
        JViewport vp = (JViewport)this.getParent();
        Point pt = vp.getViewPosition();
        pt.x = (int)((double)pt.x / (double)this._cellSize + this._originX);
        pt.y = (int)((double)pt.y / (double)this._cellSize + this._originY);
        this._cellSize *= 2;
        this.setCorner(pt.x, pt.y);
        this._originX = oldOriginX;
        this._originY = oldOriginY;
        this.revalidate();
    }

    public void zoomOut() {
        double oldOriginX = this._originX;
        double oldOriginY = this._originY;
        JViewport vp = (JViewport)this.getParent();
        Point pt = vp.getViewPosition();
        pt.x = (int)((double)pt.x / (double)this._cellSize + this._originX);
        pt.y = (int)((double)pt.y / (double)this._cellSize + this._originY);
        this._cellSize = Math.max(8, this._cellSize / 2);
        this.setCorner(pt.x, pt.y);
        this._originX = oldOriginX;
        this._originY = oldOriginY;
        this.revalidate();
    }

    public void setCorner(int x, int y) {
        DisplayViewport vp = (DisplayViewport)this.getParent();
        vp.oldSetViewPosition(new Point((int)((double)x - this._originX) * this._cellSize, (int)((double)y - this._originY) * this._cellSize));
    }

    public Dimension getPreferredSize() {
        Dimension s = this._displayAdapter.getDisplaySize();
        return new Dimension(s.width * this._cellSize, s.height * this._cellSize);
    }

    public Dimension getMinimumSize() {
        Dimension s = this._displayAdapter.getDisplaySize();
        return new Dimension(s.width * 8, s.height * 8);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this._cellSize;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return (int)((double)visibleRect.height * 0.9);
        }
        return (int)((double)visibleRect.width * 0.9);
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(420, 420);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g2);
        Rectangle curClip = g2.getClipBounds();
        Graphics2D envGraphics = (Graphics2D)g2.create();
        AffineTransform oldTransform = envGraphics.getTransform();
        int left = this.getInsets().left;
        int top = this.getInsets().top;
        int x1 = (curClip.x - left) / this._cellSize;
        int y1 = (curClip.y - top) / this._cellSize;
        int x2 = (curClip.x + curClip.width - left + this._cellSize - 1) / this._cellSize;
        int y2 = (curClip.y + curClip.height - top + this._cellSize - 1) / this._cellSize;
        envGraphics.translate(x1 * this._cellSize + left, y1 * this._cellSize + top);
        envGraphics.scale(this._cellSize, this._cellSize);
        envGraphics.setStroke(new BasicStroke(1.0f / (float)this._cellSize));
        this._displayAdapter.draw(envGraphics, this, new Point2D.Double(x1 + (int)this._originX, y1 + (int)this._originY), new Point2D.Double(x2 + (int)this._originX, y2 + (int)this._originY));
        envGraphics.setTransform(oldTransform);
    }

    public void pan(double dx, double dy) {
        this._originX = (int)(this._originX + dx / (double)this._cellSize);
        this._originY = (int)(this._originY + dy / (double)this._cellSize);
    }

    public int getCellSize() {
        return this._cellSize;
    }

    public void resetPan() {
        Point2D.Double center = this._displayAdapter.getViewPosition(new Point2D.Double(0.0, 0.0));
        this._originX = -center.x;
        this._originY = -center.y;
        this.repaint();
    }

    public String getPanTipText() {
        JViewport vp = (JViewport)this.getParent();
        Point pt = vp.getViewPosition();
        int x = (int)((double)pt.x / (double)this._cellSize + this._originX);
        int y = (int)((double)pt.y / (double)this._cellSize + this._originY);
        return "(" + x + "," + y + ")";
    }
}

