/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.IDisplayAdapter;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DisplayViewport
extends JViewport {
    private static final int ORIGIN_TIP_DELAY = 1000;
    private JScrollPane _scrollParent;
    private JPanel _glassPane;
    private JToolTip _originTip;
    private Timer _originTipTimer;
    private IDisplayAdapter _displayAdapter;
    private Point2D.Double _lastOrigin = new Point2D.Double();

    public DisplayViewport(JScrollPane parent, IDisplayAdapter da) {
        this._scrollParent = parent;
        this._displayAdapter = da;
        this.setBackground(Color.lightGray);
    }

    public void resetViewport() {
        Pannable p = this.getPannableView();
        if (p != null) {
            this._lastOrigin = this._displayAdapter.getViewPosition(new Point2D.Double(0.0, 0.0));
        }
    }

    public void oldSetViewPosition(Point pt) {
        super.setViewPosition(pt);
    }

    public void setViewPosition(Point pt) {
        boolean isAdjusting = this._scrollParent.getVerticalScrollBar().getValueIsAdjusting() || this._scrollParent.getHorizontalScrollBar().getValueIsAdjusting();
        Pannable p = this.getPannableView();
        boolean changed = !this.getViewPosition().equals(pt);
        super.setViewPosition(pt);
        if (p != null && !isAdjusting) {
            int cellSize = p.getCellSize();
            Point2D.Double delta = new Point2D.Double((double)pt.x / (double)cellSize - this._lastOrigin.x, (double)pt.y / (double)cellSize - this._lastOrigin.y);
            delta = this._displayAdapter.getPanDelta(delta);
            p.pan(delta.x * (double)cellSize, delta.y * (double)cellSize);
            Point2D.Double modelPos = new Point2D.Double((double)pt.x / (double)cellSize, (double)pt.y / (double)cellSize);
            modelPos = this._displayAdapter.getViewPosition(modelPos);
            Point pixelPos = new Point((int)(modelPos.x * (double)cellSize), (int)(modelPos.y * (double)cellSize));
            super.setViewPosition(pixelPos);
            this._lastOrigin = new Point2D.Double((double)pixelPos.x / (double)cellSize, (double)pixelPos.y / (double)cellSize);
            this.fireStateChanged();
            this.repaint();
        }
        if (isAdjusting || changed) {
            this.showOriginTip();
        }
    }

    private Pannable getPannableView() {
        return (Pannable)((Object)this.getView());
    }

    public void showOriginTip() {
        String tipText;
        if (this.getRootPane() == null) {
            return;
        }
        if (this._glassPane == null) {
            this._glassPane = new JPanel();
            this.getRootPane().setGlassPane(this._glassPane);
            this._glassPane.setOpaque(false);
            this._glassPane.setLayout(null);
            this._originTip = new JToolTip();
            this._glassPane.add(this._originTip);
            this._originTipTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DisplayViewport.this._glassPane.setVisible(false);
                }
            });
            this._originTipTimer.setRepeats(false);
        }
        if ((tipText = this.getPannableView().getPanTipText()) == null) {
            return;
        }
        this._originTip.setTipText(tipText);
        this._originTip.setLocation(SwingUtilities.convertPoint(this, this.getLocation(), this._glassPane));
        this._originTip.setSize(this._originTip.getPreferredSize());
        this._glassPane.setVisible(true);
        this._originTipTimer.restart();
    }

    public static interface Pannable {
        public void pan(double var1, double var3);

        public void resetPan();

        public int getCellSize();

        public String getPanTipText();
    }
}

