/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.IDisplayAdapter;
import controller.IEditAdapter;
import controller.IEnvAdapter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import model.RandNumGenerator;
import sysModel.fish.AFish;
import view.InputStringDialog;

public class EditToolbar
extends JToolBar
implements IEditAdapter {
    private JComboBox _colorComboBox;
    private JComboBox _fishComboBox;
    private JFrame _parentFrame;
    static /* synthetic */ Class class$java$awt$Color;

    public EditToolbar(JFrame parentFrame, IEnvAdapter ea, IDisplayAdapter da) {
        super(1);
        this.setFloatable(false);
        this.makeTools(ea, da);
        this._parentFrame = parentFrame;
    }

    public String getCurrentFish() {
        return ((FishChoice)this._fishComboBox.getSelectedItem()).getFishClassName();
    }

    public Color getCurrentColor() {
        ColorChoice cc = (ColorChoice)this._colorComboBox.getSelectedItem();
        return cc.getColor();
    }

    private void makeTools(IEnvAdapter ea, final IDisplayAdapter da) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Configure new fish"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.add(new JLabel(" Type: "));
        this._fishComboBox = new JComboBox();
        String[] fishClassNames = ea.getFishClassNames();
        for (int i = 0; i < fishClassNames.length; ++i) {
            String className = fishClassNames[i];
            this._fishComboBox.addItem(new FishChoice(className, da));
        }
        ColorChoice addNew = new ColorChoice("Add ...", Color.white){

            public void select() {
                String className = new InputStringDialog(JOptionPane.getFrameForComponent(EditToolbar.this), "Add fish class").showDialog();
                try {
                    FishChoice choice = new FishChoice(className, da);
                    EditToolbar.this._fishComboBox.insertItemAt(choice, EditToolbar.this._fishComboBox.getItemCount() - 1);
                    EditToolbar.this._fishComboBox.setSelectedItem(choice);
                    choice.select();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this._fishComboBox.addItem(addNew);
        this._fishComboBox.setRenderer(new ChoiceWithIconRenderer(this._fishComboBox));
        this._fishComboBox.setAlignmentX(0.0f);
        this._fishComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChoiceWithIcon c = (ChoiceWithIcon)EditToolbar.this._fishComboBox.getSelectedItem();
                c.select();
            }
        });
        this.add(this._fishComboBox);
        this.addSeparator();
        this.add(new JLabel(" Color: "));
        ColorChoice random = new ColorChoice("Random", ColorIcon.RANDOM_COLOR){

            public Color getColor() {
                RandNumGenerator rng = RandNumGenerator.instance();
                return new Color(rng.nextInt(256), rng.nextInt(256), rng.nextInt(256));
            }
        };
        ColorChoice other = new ColorChoice("Other ...", Color.white){

            public void select() {
                EditToolbar.this._colorComboBox.hidePopup();
                Frame parentFrame = JOptionPane.getFrameForComponent(EditToolbar.this);
                Color chosen = JColorChooser.showDialog(parentFrame, "Choose AFish Color", this.getColor());
                if (chosen != null) {
                    this.setColor(chosen);
                }
            }
        };
        ColorChoice[] standardChoices = new ColorChoice[]{new ColorChoice("Red", Color.red), new ColorChoice("Orange", new Color(255, 128, 0)), new ColorChoice("Yellow", Color.yellow), new ColorChoice("Green", Color.green), new ColorChoice("Blue", new Color(0, 128, 255)), new ColorChoice("Purple", new Color(128, 0, 128)), random, other};
        this._colorComboBox = new JComboBox<ColorChoice>(standardChoices);
        this._colorComboBox.setSelectedItem(random);
        this._colorComboBox.setRenderer(new ChoiceWithIconRenderer(this._colorComboBox));
        this._colorComboBox.setAlignmentX(0.0f);
        this._colorComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorChoice cc = (ColorChoice)EditToolbar.this._colorComboBox.getSelectedItem();
                cc.select();
            }
        });
        this.add(this._colorComboBox);
        this.add(Box.createGlue());
    }

    public void setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            super.setVisible(visible);
            Dimension cur = this._parentFrame.getSize();
            Dimension change = this.getOrientation() == 0 ? new Dimension(0, (visible ? 1 : -1) * this.getPreferredSize().height) : new Dimension((visible ? 1 : -1) * this.getPreferredSize().width, 0);
            this._parentFrame.setSize(new Dimension(cur.width + change.width, cur.height + change.height));
            this._parentFrame.validate();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            this.setVisible(enabled);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FishIcon
    implements Icon {
        private AFish _fish;
        private String _fishClassName;
        private Color _color;
        private int _width;
        private int _height;
        IDisplayAdapter _da;

        public FishIcon(String fishClassName, Color c, int w, int h, IDisplayAdapter da) {
            this._fishClassName = fishClassName;
            this._color = c;
            this._width = w;
            this._height = h;
            this._da = da;
        }

        public int getIconWidth() {
            return this._width;
        }

        public int getIconHeight() {
            return this._height;
        }

        public void paintIcon(Component comp, Graphics g, int x, int y) {
            if (this._fish == null) {
                try {
                    Class<?> envClass = Class.forName(this._fishClassName);
                    Constructor<?> envCtor = envClass.getConstructor(class$java$awt$Color == null ? (class$java$awt$Color = EditToolbar.class$("java.awt.Color")) : class$java$awt$Color);
                    this._fish = (AFish)envCtor.newInstance(Color.BLUE);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error loading fish class");
                }
            }
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform savedTransform = g2.getTransform();
            g2.translate(x + this.getIconWidth() / 2, y + this.getIconHeight() / 2);
            g2.setStroke(new BasicStroke(1.0f / (float)this.getIconHeight()));
            g2.scale(this._width, this._height);
            this._fish.paint(g2, comp);
            g2.setTransform(savedTransform);
        }
    }

    private static class ColorIcon
    implements Icon {
        public static final Color RANDOM_COLOR = new Color(0, 0, 0);
        private static final int MARGIN = 2;
        private Color _color;
        private int _width;
        private int _height;

        public ColorIcon(Color c, int w, int h) {
            this._color = c;
            this._width = w;
            this._height = h;
        }

        public void setColor(Color c) {
            this._color = c;
        }

        public int getIconWidth() {
            return this._width;
        }

        public int getIconHeight() {
            return this._height;
        }

        public void paintIcon(Component comp, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Rectangle r = new Rectangle(x + 2, y + 2, this._width - 4, this._height - 4);
            if (this._color != RANDOM_COLOR) {
                g2.setColor(this._color);
                g2.fill(r);
            } else {
                for (int k = 0; k < r.width; ++k) {
                    g2.setColor(Color.getHSBColor((float)k / (float)r.width, 0.95f, 1.0f));
                    g2.drawLine(r.x + k, r.y, r.x + k, r.y + r.height);
                }
            }
            g2.setColor(Color.black);
            g2.draw(r);
        }
    }

    private static class ChoiceWithIconRenderer
    extends JLabel
    implements ListCellRenderer {
        private JComboBox cb;

        public ChoiceWithIconRenderer(JComboBox b) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.cb = b;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
            this.setBackground(selected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(selected ? list.getSelectionForeground() : list.getForeground());
            if (!this.cb.isEnabled()) {
                this.setText("No choice");
                this.setIcon(null);
            } else {
                this.setText(value.toString());
                this.setIcon(((ChoiceWithIcon)value).getIcon());
            }
            return this;
        }
    }

    private class FishChoice
    implements ChoiceWithIcon {
        private String _fishClassName;
        private FishIcon _icon;

        public FishChoice(String fishClassName, IDisplayAdapter da) {
            this._fishClassName = fishClassName;
            this._icon = new FishIcon(this._fishClassName, Color.gray, 16, 16, da);
        }

        public String getFishClassName() {
            return this._fishClassName;
        }

        public String toString() {
            return this._fishClassName;
        }

        public Icon getIcon() {
            return this._icon;
        }

        public void select() {
        }
    }

    private class ColorChoice
    implements ChoiceWithIcon {
        private Color color;
        private String name;
        private ColorIcon icon;

        public ColorChoice(String n, Color c) {
            this.color = c;
            this.name = n;
            this.icon = new ColorIcon(this.color, 16, 16);
        }

        public void setColor(Color c) {
            this.color = c;
            this.icon.setColor(c);
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void select() {
        }
    }

    private static interface ChoiceWithIcon {
        public Icon getIcon();

        public void select();
    }
}

