/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class EnvFileChooser
extends JFileChooser {
    private static final String ENV_EXT = ".txt";
    private JPanel openAccessory;

    public EnvFileChooser() {
        super(new File(System.getProperty("user.dir") + File.separator + "DataFiles"));
        this.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(EnvFileChooser.ENV_EXT) || f.isDirectory();
            }

            public String getDescription() {
                return "RiceMBS data files (*.txt)";
            }
        });
        this.setFileSelectionMode(0);
    }

    public int showOpenDialog(Component parent) {
        this.setDialogTitle("Open environment file");
        this.setAccessory(this.openAccessory);
        this.rescanCurrentDirectory();
        return super.showOpenDialog(parent);
    }

    public int showSaveDialog(Component parent) {
        this.setDialogTitle("Save environment file");
        this.setAccessory(null);
        this.rescanCurrentDirectory();
        return super.showSaveDialog(parent);
    }

    public void approveSelection() {
        if (this.getDialogType() == 1) {
            File file = this.getSelectedFile();
            if (!file.getName().endsWith(ENV_EXT)) {
                file = new File(file.getAbsolutePath() + ENV_EXT);
                this.setSelectedFile(file);
            }
            if (file.exists() && JOptionPane.showConfirmDialog(this, "File " + file.getName() + " exists. Overwrite?", "Confirm overwrite", 2) != 0) {
                return;
            }
        }
        super.approveSelection();
    }
}

