/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.IDisplayAdapter;
import controller.IEnvAdapter;
import controller.IScrollAdapter;
import controller.ISimAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import lrs.LRStruct;
import lrs.visitor.Apply;
import model.ILambda;
import model.RandNumGenerator;
import sysModel.NoOpLambda;
import sysModel.env.AEnvFactory;
import view.CreateEnvDialog;
import view.DisplayPanel;
import view.DisplayViewport;
import view.EditToolbar;
import view.EnvFileChooser;
import view.IRunIdleAdapter;
import view.SimToolbar;

public class MBSView
extends JFrame {
    private static final String VERSION_DATE = "February 2004";
    private LRStruct _componentsThatNeedAnEnvironment;
    private LRStruct _componentsDisabledDuringRun;
    private EditToolbar _editToolbar;
    private SimToolbar _simToolbar;
    public DisplayPanel _displayPanel;
    private DisplayViewport _displayViewport;
    private JScrollPane _scrollPane;
    private EnvFileChooser _fileChooser;
    private CreateEnvDialog _createEnvDialog;
    private int _randSeed = RandNumGenerator.instance().getSeed();
    private int _stepCount = 10;
    private ILambda _indefinitelyIterLambda = new ILambda(){

        public Object apply(Object param) {
            MBSView.this._displayViewport.repaint();
            return null;
        }
    };
    IDisplayAdapter _displayAdapter;
    ISimAdapter _simAdapter;
    IEnvAdapter _envAdapter;
    IScrollAdapter _scrollAdapter;
    static /* synthetic */ Class class$view$MBSView$GUIExceptionHandler;

    public MBSView(IDisplayAdapter da, ISimAdapter sa, IEnvAdapter ea) {
        this._displayAdapter = da;
        this._simAdapter = sa;
        this._envAdapter = ea;
        this._scrollAdapter = new IScrollAdapter(){

            public void setCorner(int x, int y) {
                MBSView.this._displayPanel.setCorner(x, y);
            }

            public void resetScrolling() {
                MBSView.this._displayPanel.resetPan();
                MBSView.this._displayViewport.resetViewport();
            }
        };
        this._componentsThatNeedAnEnvironment = new LRStruct();
        this._componentsDisabledDuringRun = new LRStruct();
        System.setProperty("sun.awt.exception.handler", (class$view$MBSView$GUIExceptionHandler == null ? (class$view$MBSView$GUIExceptionHandler = MBSView.class$("view.MBSView$GUIExceptionHandler")) : class$view$MBSView$GUIExceptionHandler).getName());
        this.setTitle("Rice Marine Biology Simulation");
        this.setLocation(25, 15);
        this.setDefaultCloseOperation(3);
        JPanel content = new JPanel();
        this.setContentPane(content);
        content.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        content.setLayout(new BorderLayout());
        this._displayPanel = new DisplayPanel(this._displayAdapter, this._envAdapter);
        this._scrollPane = new JScrollPane(this._displayPanel, 22, 32);
        this._displayViewport = new DisplayViewport(this._scrollPane, this._displayAdapter);
        this._scrollPane.setViewport(this._displayViewport);
        this._scrollPane.setViewportView(this._displayPanel);
        this._scrollPane.setPreferredSize(this._displayPanel.getPreferredSize());
        content.add((Component)this._scrollPane, "Center");
        this._editToolbar = new EditToolbar(this, this._envAdapter, this._displayAdapter);
        content.add((Component)this._editToolbar, "East");
        this._simToolbar = new SimToolbar(this._simAdapter, new IRunIdleAdapter(){

            public void setRunState() {
                MBSView.setComponentsEnabled(MBSView.this._componentsDisabledDuringRun, false);
                MBSView.this.setEditModeEnable(false);
                MBSView.this._displayViewport.repaint();
            }

            public void setIdleState() {
                MBSView.setComponentsEnabled(MBSView.this._componentsDisabledDuringRun, true);
                MBSView.this._displayViewport.repaint();
            }
        });
        this._simToolbar.setVisible(true);
        this._simToolbar.setEnabled(false);
        content.add((Component)this._simToolbar, "South");
        this._componentsThatNeedAnEnvironment.insertFront(this._simToolbar);
        this._fileChooser = new EnvFileChooser();
        this._createEnvDialog = new CreateEnvDialog(this, this._envAdapter);
        this.setEditModeEnable(false);
        this.makeMenus();
        this._simAdapter.setIterationLambda(this._indefinitelyIterLambda);
    }

    private void makeMenus() {
        int menuMask = this.getToolkit().getMenuShortcutKeyMask();
        JMenuBar mbar = new JMenuBar();
        JMenu menu = new JMenu("File");
        mbar.add(menu);
        JMenuItem mItem = new JMenuItem("Open environment file...");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MBSView.this._fileChooser.showOpenDialog(MBSView.this) == 0) {
                    MBSView.this._simAdapter.stop();
                    MBSView.this._simToolbar.setControlsInIdleState();
                    MBSView.setComponentsEnabled(MBSView.this._componentsThatNeedAnEnvironment, true);
                    MBSView.this.setEditModeEnable(false);
                    MBSView.this._envAdapter.loadEnvironment(MBSView.this._fileChooser.getSelectedFile().getAbsoluteFile().toString());
                    MBSView.this._displayPanel.revalidate();
                    MBSView.this._scrollAdapter.resetScrolling();
                    MBSView.this._displayAdapter.returnHome(MBSView.this._scrollAdapter);
                }
            }
        });
        mItem.setAccelerator(KeyStroke.getKeyStroke(79, menuMask));
        mItem = new JMenuItem("Create new environment...");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AEnvFactory settings = MBSView.this._createEnvDialog.showDialog();
                if (settings != null) {
                    MBSView.this._simAdapter.stop();
                    MBSView.this._simToolbar.setControlsInIdleState();
                    MBSView.setComponentsEnabled(MBSView.this._componentsThatNeedAnEnvironment, true);
                    MBSView.this.setEditModeEnable(false);
                    MBSView.this._envAdapter.createEnvironment(settings);
                    MBSView.this._displayPanel.revalidate();
                    MBSView.this._scrollAdapter.resetScrolling();
                    MBSView.this._displayAdapter.returnHome(MBSView.this._scrollAdapter);
                }
            }
        });
        mItem.setAccelerator(KeyStroke.getKeyStroke(78, menuMask));
        mItem = new JMenuItem("Edit environment...");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this.setEditModeEnable(true);
            }
        });
        mItem.setAccelerator(KeyStroke.getKeyStroke(69, menuMask));
        this._componentsThatNeedAnEnvironment.insertFront(mItem);
        mItem = new JMenuItem("Save environment as...");
        menu.add(mItem);
        mItem.setAccelerator(KeyStroke.getKeyStroke(83, menuMask));
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MBSView.this._fileChooser.showSaveDialog(MBSView.this) == 0) {
                    MBSView.setComponentsEnabled(MBSView.this._componentsThatNeedAnEnvironment, true);
                    MBSView.this.setEditModeEnable(false);
                    MBSView.this._envAdapter.saveEnvironment(MBSView.this._fileChooser.getSelectedFile().getAbsoluteFile().toString());
                }
            }
        });
        this._componentsThatNeedAnEnvironment.insertFront(mItem);
        mItem = new JMenuItem("Quit");
        menu.add(mItem);
        mItem.setAccelerator(KeyStroke.getKeyStroke(81, menuMask));
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu = new JMenu("Seed");
        mbar.add(menu);
        ButtonGroup bGroup = new ButtonGroup();
        mItem = new JRadioButtonMenuItem("Don't change seed", true);
        menu.add(mItem);
        bGroup.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this._envAdapter.setSeedLambda(NoOpLambda.instance());
            }
        });
        mItem = new JRadioButtonMenuItem("Use fixed seed...");
        menu.add(mItem);
        bGroup.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Integer seed = MBSView.queryForInteger("Enter seed for random number generator:", "Input", MBSView.this._randSeed == 0 ? 17 : MBSView.this._randSeed, MBSView.this);
                if (seed != null) {
                    MBSView.this._randSeed = seed;
                    MBSView.this._envAdapter.setSeedLambda(new ILambda(this, seed){
                        private final /* synthetic */ Integer val$seed;
                        private final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$seed = val$seed;
                        }

                        public Object apply(Object param) {
                            RandNumGenerator.instance().setSeed(this.val$seed);
                            return null;
                        }
                    });
                }
            }
        });
        mItem = new JRadioButtonMenuItem("Prompt for seed");
        menu.add(mItem);
        bGroup.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this._envAdapter.setSeedLambda(new ILambda(this){
                    private final /* synthetic */ 12 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object apply(Object param) {
                        Integer seed = MBSView.access$700("Enter seed for random number generator:", "Input", MBSView.access$600(12.access$800(this.this$1)) == 0 ? 17 : MBSView.access$600(12.access$800(this.this$1)), 12.access$800(this.this$1));
                        if (seed != null) {
                            MBSView.access$602(12.access$800(this.this$1), seed);
                            RandNumGenerator.instance().setSeed(seed);
                        }
                        return null;
                    }
                });
            }

            static /* synthetic */ MBSView access$800(12 x0) {
                return x0.MBSView.this;
            }
        });
        menu = new JMenu("Run");
        mbar.add(menu);
        bGroup = new ButtonGroup();
        mItem = new JRadioButtonMenuItem("Run Indefinitely", true);
        menu.add(mItem);
        bGroup.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this._simAdapter.setStartLambda(new ILambda(this){
                    private final /* synthetic */ 14 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object apply(Object param) {
                        return null;
                    }
                });
                MBSView.this._simAdapter.setIterationLambda(MBSView.this._indefinitelyIterLambda);
            }
        });
        this._componentsDisabledDuringRun.insertFront(mItem);
        mItem = new JRadioButtonMenuItem("Use fixed number of steps...");
        menu.add(mItem);
        bGroup.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Integer steps = MBSView.queryForInteger("Enter number of steps:", "Input", MBSView.this._stepCount, MBSView.this);
                if (steps != null) {
                    MBSView.this._stepCount = steps;
                    StepItLambda itLambda = new StepItLambda(MBSView.this._simAdapter, MBSView.this._displayViewport, MBSView.this._simToolbar);
                    MBSView.this._simAdapter.setStartLambda(new ILambda(this, itLambda, steps){
                        private final /* synthetic */ StepItLambda val$itLambda;
                        private final /* synthetic */ Integer val$steps;
                        private final /* synthetic */ 16 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$itLambda = val$itLambda;
                            this.val$steps = val$steps;
                        }

                        public Object apply(Object param) {
                            this.val$itLambda.setSteps(this.val$steps);
                            return null;
                        }
                    });
                    MBSView.this._simAdapter.setIterationLambda(itLambda);
                }
            }
        });
        this._componentsDisabledDuringRun.insertFront(mItem);
        mItem = new JRadioButtonMenuItem("Prompt for number of steps");
        menu.add(mItem);
        bGroup.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StepItLambda itLambda = new StepItLambda(MBSView.this._simAdapter, MBSView.this._displayViewport, MBSView.this._simToolbar);
                MBSView.this._simAdapter.setStartLambda(new ILambda(this, itLambda){
                    private final /* synthetic */ StepItLambda val$itLambda;
                    private final /* synthetic */ 18 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$itLambda = val$itLambda;
                    }

                    public Object apply(Object param) {
                        Integer steps = MBSView.access$700("Enter number of steps:", "Input", MBSView.access$1000(18.access$1100(this.this$1)), 18.access$1100(this.this$1));
                        if (steps != null) {
                            MBSView.access$1002(18.access$1100(this.this$1), steps);
                            this.val$itLambda.setSteps(steps);
                        }
                        return null;
                    }
                });
                MBSView.this._simAdapter.setIterationLambda(itLambda);
            }

            static /* synthetic */ MBSView access$1100(18 x0) {
                return x0.MBSView.this;
            }
        });
        this._componentsDisabledDuringRun.insertFront(mItem);
        menu = new JMenu("View");
        mbar.add(menu);
        mItem = new JMenuItem("Zoom in");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this._displayPanel.zoomIn();
            }
        });
        mItem.setAccelerator(KeyStroke.getKeyStroke(38, menuMask));
        this._componentsThatNeedAnEnvironment.insertFront(mItem);
        mItem = new JMenuItem("Zoom out");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this._displayPanel.zoomOut();
            }
        });
        mItem.setAccelerator(KeyStroke.getKeyStroke(40, menuMask));
        this._componentsThatNeedAnEnvironment.insertFront(mItem);
        mItem = new JMenuItem("Bring (0, 0) to upper left");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this._scrollAdapter.resetScrolling();
                MBSView.this._displayAdapter.returnHome(MBSView.this._scrollAdapter);
            }
        });
        mItem.setAccelerator(KeyStroke.getKeyStroke(67, menuMask));
        this._componentsThatNeedAnEnvironment.insertFront(mItem);
        menu = new JMenu("Help");
        mbar.add(menu);
        mItem = new JMenuItem("About RiceMBS...");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this.showAboutPanel();
            }
        });
        mItem = new JMenuItem("Help...");
        menu.add(mItem);
        mItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MBSView.this.showHelp();
            }
        });
        mItem.setAccelerator(KeyStroke.getKeyStroke(156, menuMask));
        MBSView.setComponentsEnabled(this._componentsThatNeedAnEnvironment, false);
        MBSView.setComponentsEnabled(this._componentsDisabledDuringRun, true);
        this.setJMenuBar(mbar);
    }

    public static void setComponentsEnabled(LRStruct list, final boolean enable) {
        list.execute(Apply.Singleton, new ILambda(){

            public Object apply(Object param) {
                ((JComponent)param).setEnabled(enable);
                return null;
            }
        });
    }

    public void setEditModeEnable(boolean enable) {
        if (enable != this._editToolbar.isEnabled()) {
            this._editToolbar.setEnabled(enable);
            this._displayPanel.enableMouseAdapter(enable);
        }
    }

    private void showAboutPanel() {
        String html = "<html><h2>Rice Marine Biology Simulation Program</h2>A tool for running and viewing the AP&reg; Computer Science<p>Marine Biology Simulation case study program.<p><p><font size=-1>Version: February 2004</font><p><font size=-1>Copyright&copy; 2002 College Entrance Examination Board (www.collegeboard.com).<br><font size=-1>Copyright&copy; 2003 Rice University (www.rice.edu).</font></font></html>";
        JOptionPane.showMessageDialog(this, new JLabel(html), "About RiceMBS", 1, null);
    }

    private void showHelp() {
        JDialog dialog = new JDialog((Frame)this, "RiceMBS Help");
        final JEditorPane helpText = new JEditorPane();
        try {
            helpText.setPage(new URL("file", "", System.getProperty("user.dir") + File.separator + "Resources" + File.separator + "MBSHelp.html"));
        }
        catch (Exception e) {
            helpText.setText("Couldn't load help file.");
        }
        helpText.setEditable(false);
        helpText.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent ev) {
                if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        helpText.setPage(ev.getURL());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        JScrollPane sp = new JScrollPane(helpText);
        sp.setPreferredSize(new Dimension(650, 500));
        dialog.getContentPane().add(sp);
        dialog.setLocation(this.getX() + this.getWidth() - 200, this.getY() + 50);
        dialog.pack();
        dialog.setVisible(true);
    }

    private static Integer queryForInteger(String message, String prompt, int suggestion, JFrame parentFrame) {
        String str = (String)JOptionPane.showInputDialog(parentFrame, message, prompt, 3, null, null, "" + suggestion);
        if (str != null) {
            try {
                return new Integer(Integer.parseInt(str.trim()));
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return null;
    }

    public String getCurrentFish() {
        return this._editToolbar.getCurrentFish();
    }

    public Color getCurrentColor() {
        return this._editToolbar.getCurrentColor();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StepItLambda
    implements ILambda {
        int _steps = 0;
        ISimAdapter _simAdapter;
        DisplayViewport _displayViewport;
        SimToolbar _simToolbar;

        public StepItLambda(ISimAdapter sa, DisplayViewport vp, SimToolbar st) {
            this._simAdapter = sa;
            this._displayViewport = vp;
            this._simToolbar = st;
        }

        public void setSteps(int steps) {
            this._steps = steps;
        }

        public Object apply(Object param) {
            --this._steps;
            if (this._steps <= 0) {
                this._simAdapter.stop();
                this._simToolbar.setControlsInIdleState();
            }
            this._displayViewport.repaint();
            return null;
        }
    }

    public static class GUIExceptionHandler {
        public void handle(Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "An error occurred. The simulation must exit.\nReason: " + e, "Error", 0);
            System.exit(0);
        }
    }
}

