/*
 * Decompiled with CFR 0.152.
 */
package view;

import controller.ISimAdapter;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import view.IRunIdleAdapter;

public class SimToolbar
extends JToolBar {
    private static final int MIN_DELAY_MSECS = 10;
    private static final int MAX_DELAY_MSECS = 1000;
    private static final int INITIAL_DELAY = 505;
    IRunIdleAdapter _riAdapter;
    JButton _stepButton;
    JButton _runButton;
    JButton _stopButton;
    JSlider _speedSlider;
    ISimAdapter _simAdapter;

    public SimToolbar(ISimAdapter sa, IRunIdleAdapter ria) {
        super(1);
        this.setFloatable(false);
        this.makeTools();
        this._riAdapter = ria;
        this._simAdapter = sa;
    }

    private void makeTools() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createTitledBorder("Simulation"));
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this._stepButton = new JButton("Step");
        this.add(this._stepButton);
        this._runButton = new JButton("Run");
        this.add(this._runButton);
        this._stopButton = new JButton("Stop");
        this.add(this._stopButton);
        this._runButton.setEnabled(false);
        this._stepButton.setEnabled(false);
        this._stopButton.setEnabled(false);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(new JLabel("Slow"));
        this._speedSlider = new JSlider(10, 1000, 505);
        this._speedSlider.setInverted(true);
        this._speedSlider.setPreferredSize(new Dimension(100, this._speedSlider.getPreferredSize().height));
        this._speedSlider.setMaximumSize(this._speedSlider.getPreferredSize());
        this.add(this._speedSlider);
        this._speedSlider.setEnabled(false);
        this.add(new JLabel("Fast"));
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this._stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimToolbar.this.setControlsInRunState();
                SimToolbar.this._simAdapter.step();
                SimToolbar.this.setControlsInIdleState();
            }
        });
        this._runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimToolbar.this.setControlsInRunState();
                SimToolbar.this._simAdapter.setSpeed(SimToolbar.this._speedSlider.getValue());
                SimToolbar.this._simAdapter.start();
            }
        });
        this._stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimToolbar.this.setControlsInIdleState();
                SimToolbar.this._simAdapter.stop();
            }
        });
        this._speedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SimToolbar.this._simAdapter.setSpeed(((JSlider)evt.getSource()).getValue());
            }
        });
    }

    public void setControlsInIdleState() {
        this._stepButton.setEnabled(true);
        this._runButton.setEnabled(true);
        this._stopButton.setEnabled(false);
        this._speedSlider.setEnabled(true);
        this._riAdapter.setIdleState();
    }

    public void setControlsInRunState() {
        this._stepButton.setEnabled(false);
        this._runButton.setEnabled(false);
        this._stopButton.setEnabled(true);
        this._speedSlider.setEnabled(true);
        this._riAdapter.setRunState();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._stepButton.setEnabled(enabled);
        this._runButton.setEnabled(enabled);
        this._stopButton.setEnabled(false);
        this._speedSlider.setEnabled(enabled);
    }
}

