package model.fish;

import model.ILambda;
import model.fish.display.ImageFishDisplay;
import sysModel.fish.AFish;

import java.awt.*;

/**
 * A simple fish that swims back and forth.
 *
 * @author Mathias Ricken
 */
public class SimpleFish extends AFish {
    /**
     * Constructor.
     *
     * @param fishColor color of the fish
     */
    public SimpleFish(Color fishColor) {
        super(fishColor, new ImageFishDisplay("smallfish.gif", 3.0 * Math.PI / 2.0));
    }

    /**
     * Move the fish.
     */
    protected void move() {
        // attempt to move forward
        tryMoveFwd(new ILambda() {
            public Object apply(Object param) {
                // cannot move
                // turn PI radians
                turnRight(Math.PI);
                return null;
            }
        }, new ILambda() {
            public Object apply(Object param) {
                // can move forward, do it
                ((ILambda) param).apply(null);
                return null;
            }
        });
    }
}
