package lrs;

/**
 * Represents the empty state of a mutable list LRStruct. Uses the
 * Singleton pattern.
 *
 * @author Dung X. Nguyen  Copyright 2001 - All rights reserved.
 * @since 10/09/01
 */
class EmptyNode extends ANode {
    /**
     * Singleton Pattern.
     */
    final static EmptyNode Singleton = new EmptyNode();

    private EmptyNode() {
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct getRest(LRStruct owner) {
        throw new java.util.NoSuchElementException("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    Object getFirst(LRStruct owner) {
        throw new java.util.NoSuchElementException("Empty list has no first.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct setRest(LRStruct tail, LRStruct owner) {
        throw new java.util.NoSuchElementException("Empty list has no tail.");
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    LRStruct setFirst(Object dat, LRStruct owner) {
        throw new java.util.NoSuchElementException("Empty list has no first.");
    }

    /**
     * The owner becomes non-empty and has dat as its first element.
     */
    LRStruct insertFront(Object dat, LRStruct owner) {
        return owner.setHead(new NENode(dat, new LRStruct(this)));
    }

    /**
     * Throws java.util.NoSuchElementException.
     */
    Object removeFront(LRStruct owner) {
        throw new java.util.NoSuchElementException("Empty list has no front.");
    }

    /**
     * Calls the <code>IAlgo</code> visitor's empty case.
     */
    Object execute(IAlgo algo, Object inp, LRStruct owner) {
        return algo.emptyCase(owner, inp);
    }
}

