package lrs.visitor;

import lrs.IAlgo;
import lrs.LRStruct;
import model.ILambda;

/**
 * Applies the lambda specified as input to all elements in the LRStruct.
 *
 * @author Mathias Ricken
 */
public class Apply implements IAlgo {
    /// singleton instance
    public static final Apply Singleton = new Apply();

    /// private singleton ctor
    private Apply() {
    }

    /**
     * Operates on an empty LRStruct host, given an input object.
     *
     * @param host an empty LRStruct.
     * @param inp  ILambda to apply
     * @return always null
     */
    public Object emptyCase(LRStruct host, Object inp) {
        return null;
    }

    /**
     * Operates on a non-empty LRStruct host, given an input object.
     *
     * @param host a non-empty LRStruct.
     * @param inp  ILambda to apply
     * @return always null
     */
    public Object nonEmptyCase(LRStruct host, Object inp) {
        ((ILambda) inp).apply(host.getFirst());
        return host.getRest().execute(this, inp);
    }
}
